% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content.R
\name{search_content}
\alias{search_content}
\title{Search for content on the Connect server}
\usage{
search_content(
  client,
  q = NULL,
  include = "owner,vanity_url",
  page_size = 500,
  limit = Inf,
  ...
)
}
\arguments{
\item{client}{A Connect object}

\item{q}{The search query, using the syntax described in the Connect
documentation on \href{https://docs.posit.co/connect/user/viewing-content/#searching-content}{content search terms}}

\item{include}{Comma-separated character string of values indicating additional
details to include in the response. Values can be \code{owner} and \code{vanity_url};
both are included by default.}

\item{page_size}{The number of items to fetch per page. Maximum is 500.}

\item{limit}{Maximum number of items to return overall. Defaults to \code{Inf} (all items).}

\item{...}{Additional query parameters passed to the API for future expansion.
Note: If you pass \code{page_number} here, it will affect the \emph{starting} page
for pagination, but all subsequent pages will still be fetched. This is
usually not what you want.}
}
\value{
A list of \link{Content} objects, of class "connect_content_list"
}
\description{
Search for content on the Connect server
}
\details{
Please see https://docs.posit.co/connect/api/#get-/v1/search/content for more
information.
}
\examples{
\dontrun{
library(connectapi)
client <- connect()

my_content <- search_content(client, q = "owner:@me")

shiny_content <- purrr::keep(my_content, function(x) {
  x$content$app_mode == "rmd-shiny"
})

purrr::map(shiny_content, lock_content)
}

}
\seealso{
Other content functions: 
\code{\link{content_delete}()},
\code{\link{content_item}()},
\code{\link{content_title}()},
\code{\link{content_update}()},
\code{\link{create_random_name}()},
\code{\link{dashboard_url}()},
\code{\link{delete_thumbnail}()},
\code{\link{delete_vanity_url}()},
\code{\link{deploy_repo}()},
\code{\link{get_associations}()},
\code{\link{get_bundles}()},
\code{\link{get_environment}()},
\code{\link{get_image}()},
\code{\link{get_jobs}()},
\code{\link{get_log}()},
\code{\link{get_thumbnail}()},
\code{\link{get_vanity_url}()},
\code{\link{git}},
\code{\link{has_thumbnail}()},
\code{\link{lock_content}()},
\code{\link{permissions}},
\code{\link{set_image_path}()},
\code{\link{set_integrations}()},
\code{\link{set_run_as}()},
\code{\link{set_thumbnail}()},
\code{\link{set_vanity_url}()},
\code{\link{swap_vanity_urls}()},
\code{\link{terminate_jobs}()},
\code{\link{verify_content_name}()}
}
\concept{content functions}
