% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output-save.R
\name{sn_save}
\alias{sn_save}
\title{Save Network Visualization}
\usage{
sn_save(network, filename, width = 7, height = 7, dpi = 300, title = NULL, ...)
}
\arguments{
\item{network}{A cograph_network object, matrix, data.frame, or igraph object.
Matrices and other inputs are auto-converted.}

\item{filename}{Output filename. Format is detected from extension.}

\item{width}{Width in inches (default 7).}

\item{height}{Height in inches (default 7).}

\item{dpi}{Resolution for raster formats (default 300).}

\item{title}{Optional plot title.}

\item{...}{Additional arguments passed to the graphics device.}
}
\value{
Invisible filename.
}
\description{
Save a Cograph network visualization to a file.
}
\examples{
\donttest{
adj <- matrix(c(0, 1, 1, 1, 0, 1, 1, 1, 0), nrow = 3)
# With cograph()
net <- cograph(adj)
sn_save(net, file.path(tempdir(), "network.pdf"))

# Direct matrix input
sn_save(adj, file.path(tempdir(), "network.png"), dpi = 300)
}
}
