% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render-ggplot.R
\name{sn_ggplot}
\alias{sn_ggplot}
\title{Convert Network to ggplot2}
\usage{
sn_ggplot(network, title = NULL)
}
\arguments{
\item{network}{A cograph_network object, matrix, data.frame, or igraph object.
Matrices and other inputs are auto-converted.}

\item{title}{Optional plot title.}
}
\value{
A ggplot2 object.
}
\description{
Convert a Cograph network visualization to a ggplot2 object for further
customization and composability.
}
\examples{
adj <- matrix(c(0, 1, 1, 1, 0, 1, 1, 1, 0), nrow = 3)
# With cograph()
p <- cograph(adj) |> sn_ggplot()
print(p)

# Direct matrix input
p <- adj |> sn_ggplot()

# Further customization
p + ggplot2::labs(title = "My Network")
}
