% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-constants.R
\name{scale_edge_widths}
\alias{scale_edge_widths}
\title{Scale Edge Widths Based on Weights}
\usage{
scale_edge_widths(
  weights,
  esize = NULL,
  n_nodes = NULL,
  directed = FALSE,
  mode = "linear",
  maximum = NULL,
  minimum = 0,
  cut = NULL,
  range = c(0.5, 4)
)
}
\arguments{
\item{weights}{Numeric vector of edge weights.}

\item{esize}{Base edge size. NULL uses adaptive sizing based on n_nodes.}

\item{n_nodes}{Number of nodes (for adaptive esize calculation).}

\item{directed}{Whether network is directed (affects adaptive esize).}

\item{mode}{Scaling mode: "linear", "log", "sqrt", or "rank".}

\item{maximum}{Max weight for normalization. NULL for auto-detect.}

\item{minimum}{Min weight threshold. Edges below this get minimum width.}

\item{cut}{Two-tier cutoff threshold. NULL = auto (75th percentile),
0 = disabled (continuous scaling), positive number = manual threshold.}

\item{range}{Output width range as c(min_width, max_width).}
}
\value{
Numeric vector of scaled edge widths.
}
\description{
Unified edge width scaling function that supports multiple scaling modes,
two-tier cutoff system (like qgraph), and output range specification.
}
\details{
\subsection{Scaling Modes}{
\itemize{
\item \strong{linear} (default): Direct proportional scaling, matches qgraph behavior.
\item \strong{log}: Logarithmic scaling for wide weight ranges. Uses log1p for stability.
\item \strong{sqrt}: Square root scaling for moderate compression.
\item \strong{rank}: Rank-based scaling for equal visual spacing regardless of weight distribution.
}
}

\subsection{Two-Tier System (cut parameter)}{

When cut > 0, edges are divided into two tiers:
\itemize{
\item Below cut: Minimal width variation (20\% of range)
\item Above cut: Full width scaling (80\% of range)
}

This matches qgraph's behavior where weak edges are visually de-emphasized.
}
}
\keyword{internal}
