% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-globals.R
\name{register_shape}
\alias{register_shape}
\title{Register a Custom Shape}
\usage{
register_shape(name, draw_fn)
}
\arguments{
\item{name}{Character. Name of the shape.}

\item{draw_fn}{Function. A function that draws the shape. Should accept
parameters: x, y, size, fill, border_color, border_width, ...}
}
\value{
Invisible NULL.
}
\description{
Register a new shape that can be used for node rendering.
}
\examples{
# Register a custom hexagon shape
register_shape("hexagon", function(x, y, size, fill, border_color, border_width, ...) {
  angles <- seq(0, 2 * pi, length.out = 7)
  grid::polygonGrob(
    x = x + size * cos(angles),
    y = y + size * sin(angles),
    gp = grid::gpar(fill = fill, col = border_color, lwd = border_width)
  )
})
}
