% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-globals.R
\name{register_layout}
\alias{register_layout}
\title{Register a Custom Layout}
\usage{
register_layout(name, layout_fn)
}
\arguments{
\item{name}{Character. Name of the layout.}

\item{layout_fn}{Function. A function that computes node positions.
Should accept a CographNetwork object and return a matrix with x, y columns.}
}
\value{
Invisible NULL.
}
\description{
Register a new layout algorithm that can be used for network visualization.
}
\examples{
# Register a simple random layout
register_layout("random", function(network, ...) {
  n <- network$n_nodes
  cbind(x = runif(n), y = runif(n))
})
}
