% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapes-special.R
\name{draw_donut}
\alias{draw_donut}
\title{Draw Donut Node}
\usage{
draw_donut(
  x,
  y,
  size,
  fill,
  border_color,
  border_width,
  alpha = 1,
  values = NULL,
  colors = NULL,
  inner_ratio = 0.5,
  bg_color = "gray90",
  show_value = TRUE,
  value_size = 8,
  value_color = "black",
  value_fontface = "bold",
  value_fontfamily = "sans",
  value_digits = 2,
  value_prefix = "",
  value_suffix = "",
  value_format = NULL,
  donut_border_width = NULL,
  ...
)
}
\arguments{
\item{x, y}{Node center coordinates (NPC units).}

\item{size}{Node radius (NPC units).}

\item{fill}{Fill color for the donut ring.}

\item{border_color}{Border color.}

\item{border_width}{Border line width.}

\item{alpha}{Transparency (0-1).}

\item{values}{Single numeric value (0-1) specifying fill proportion.
0.1 = 10\% filled arc, 0.5 = 50\% filled, 1.0 = full ring.}

\item{colors}{Override fill color (optional).}

\item{inner_ratio}{Ratio of inner to outer radius (0-1). Default 0.5.}

\item{bg_color}{Background color for unfilled portion. Default "gray90".}

\item{show_value}{Logical: show value in center? Default FALSE.}

\item{value_size}{Font size for center value.}

\item{value_color}{Color for center value text.}

\item{value_fontface}{Font face for center value.}

\item{value_fontfamily}{Font family for center value.}

\item{value_digits}{Decimal places for value display.}

\item{value_prefix}{Text before value (e.g., "$").}

\item{value_suffix}{Text after value (e.g., "\%").}

\item{value_format}{Custom format function (overrides digits).}

\item{donut_border_width}{Border width for donut ring (NULL = use border_width).}
}
\description{
Draw a donut chart node showing a fill proportion (0-1) as an arc.
The fill starts from 12 o'clock (top) and fills clockwise.
}
\keyword{internal}
