% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-theme.R
\name{CographTheme}
\alias{CographTheme}
\title{CographTheme R6 Class}
\description{
Class for managing visual themes for network plots.
}
\examples{
# Create a custom theme
theme <- CographTheme$new(
  background = "white",
  node_fill = "steelblue",
  edge_color = "gray60"
)
}
\keyword{internal}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{name}}{Theme name.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CographTheme-new}{\code{CographTheme$new()}}
\item \href{#method-CographTheme-get}{\code{CographTheme$get()}}
\item \href{#method-CographTheme-set}{\code{CographTheme$set()}}
\item \href{#method-CographTheme-get_all}{\code{CographTheme$get_all()}}
\item \href{#method-CographTheme-merge}{\code{CographTheme$merge()}}
\item \href{#method-CographTheme-clone_theme}{\code{CographTheme$clone_theme()}}
\item \href{#method-CographTheme-print}{\code{CographTheme$print()}}
\item \href{#method-CographTheme-clone}{\code{CographTheme$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographTheme-new"></a>}}
\if{latex}{\out{\hypertarget{method-CographTheme-new}{}}}
\subsection{Method \code{new()}}{
Create a new CographTheme object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographTheme$new(
  name = "custom",
  background = "white",
  node_fill = "#4A90D9",
  node_border = "#2C5AA0",
  node_border_width = 1,
  edge_color = "gray50",
  edge_positive_color = "#2E7D32",
  edge_negative_color = "#C62828",
  edge_width = 1,
  label_color = "black",
  label_size = 10,
  title_color = "black",
  title_size = 14,
  legend_background = "white"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Theme name (optional).}

\item{\code{background}}{Background color.}

\item{\code{node_fill}}{Default node fill color.}

\item{\code{node_border}}{Default node border color.}

\item{\code{node_border_width}}{Default node border width.}

\item{\code{edge_color}}{Default edge color.}

\item{\code{edge_positive_color}}{Color for positive edge weights.}

\item{\code{edge_negative_color}}{Color for negative edge weights.}

\item{\code{edge_width}}{Default edge width.}

\item{\code{label_color}}{Default label color.}

\item{\code{label_size}}{Default label size.}

\item{\code{title_color}}{Title color.}

\item{\code{title_size}}{Title size.}

\item{\code{legend_background}}{Legend background color.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new CographTheme object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographTheme-get"></a>}}
\if{latex}{\out{\hypertarget{method-CographTheme-get}{}}}
\subsection{Method \code{get()}}{
Get a theme parameter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographTheme$get(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Parameter name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Parameter value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographTheme-set"></a>}}
\if{latex}{\out{\hypertarget{method-CographTheme-set}{}}}
\subsection{Method \code{set()}}{
Set a theme parameter.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographTheme$set(name, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Parameter name.}

\item{\code{value}}{Parameter value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographTheme-get_all"></a>}}
\if{latex}{\out{\hypertarget{method-CographTheme-get_all}{}}}
\subsection{Method \code{get_all()}}{
Get all theme parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographTheme$get_all()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
List of parameters.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographTheme-merge"></a>}}
\if{latex}{\out{\hypertarget{method-CographTheme-merge}{}}}
\subsection{Method \code{merge()}}{
Merge with another theme.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographTheme$merge(other)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{other}}{Another CographTheme or list of parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new merged CographTheme.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographTheme-clone_theme"></a>}}
\if{latex}{\out{\hypertarget{method-CographTheme-clone_theme}{}}}
\subsection{Method \code{clone_theme()}}{
Clone the theme.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographTheme$clone_theme()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A new CographTheme.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographTheme-print"></a>}}
\if{latex}{\out{\hypertarget{method-CographTheme-print}{}}}
\subsection{Method \code{print()}}{
Print theme summary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographTheme$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CographTheme-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CographTheme-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CographTheme$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
