% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wald_test.R
\name{Wald_test}
\alias{Wald_test}
\title{Test parameter constraints in a fitted linear regression model}
\usage{
Wald_test(
  obj,
  constraints,
  vcov,
  null_constant = 0,
  test = "HTZ",
  tidy = FALSE,
  adjustment_method = "none",
  ...
)
}
\arguments{
\item{obj}{Fitted model for which to calculate Wald tests.}

\item{constraints}{constraint or list of multiple constraints to test. See
details and examples.}

\item{vcov}{Variance covariance matrix estimated using \code{vcovCR} or a
character string specifying which small-sample adjustment should be used to
calculate the variance-covariance.}

\item{null_constant}{vector of null values or list of such vectors for each
set of constraints to test. For a single \code{constraint}, the null values
must have length equal to the number of rows in the constraint. For lists
of null values, each entry must have length equal to the number of rows in
the corresponding entry of \code{constraints}. Default is \code{0}, in
which case the null values are taken to be zero (for every entry, if
\code{constraints} is a list).}

\item{test}{Character vector specifying which small-sample correction(s) to
calculate. The following corrections are available: \code{"chi-sq"},
\code{"Naive-F"}, \code{"Naive-Fp"}, \code{"HTA"}, \code{"HTB"},
\code{"HTZ"}, \code{"EDF"}, \code{"EDT"}. Default is \code{"HTZ"}.}

\item{tidy}{Logical value controlling whether to tidy the test results. If
\code{constraints} is a list with multiple constraints, the result will be
coerced into a data frame when \code{tidy = TRUE}.}

\item{adjustment_method}{A character string indicating a multiple comparisons
correction to apply to p-values in instances where multiple tests are run.
Possible options are from \code{\link[stats]{p.adjust.methods}}, which is
passed to \code{\link[stats]{p.adjust}} to correct p-values for multiple
comparisons. Defaults to \code{"none"}.}

\item{...}{Further arguments passed to \code{\link{vcovCR}}, which are only
needed if \code{vcov} is a character string.}
}
\value{
A list of test results.
}
\description{
\code{Wald_test} reports Wald-type tests of linear contrasts from a fitted
linear regression model, using a sandwich estimator for the
variance-covariance matrix and a small sample correction for the p-value.
Several different small-sample corrections are available.
}
\details{
Constraints can be specified directly as q X p matrices or
  indirectly through \code{\link{constrain_equal}},
  \code{\link{constrain_zero}}, or \code{\link{constrain_pairwise}}. By
  default, each constraint will be tested against the null hypothesis that it
  equal to a zero vector. Non-zero values for null-hypotheses can be
  specified using the \code{null_constant} argument.
}
\examples{


if (requireNamespace("carData", quietly = TRUE)) withAutoprint({

data(Duncan, package = "carData")
Duncan$cluster <- sample(LETTERS[1:8], size = nrow(Duncan), replace = TRUE)

Duncan_fit <- lm(prestige ~ 0 + type + income + type:income + type:education, data=Duncan)
# Note that type:income terms are interactions because main effect of income is included
# but type:education terms are separate slopes for each unique level of type

# Test equality of intercepts
Wald_test(Duncan_fit,
          constraints = constrain_equal(1:3),
          vcov = "CR2", cluster = Duncan$cluster)

# Test equality of type-by-education slopes
Wald_test(Duncan_fit,
          constraints = constrain_equal(":education", reg_ex = TRUE),
          vcov = "CR2", cluster = Duncan$cluster)

# Pairwise comparisons of type-by-education slopes
Wald_test(Duncan_fit,
          constraints = constrain_pairwise(":education", reg_ex = TRUE),
          vcov = "CR2", cluster = Duncan$cluster)

# Test type-by-income interactions
Wald_test(Duncan_fit,
          constraints = constrain_zero(":income", reg_ex = TRUE),
          vcov = "CR2", cluster = Duncan$cluster)

# Pairwise comparisons of type-by-income interactions
Wald_test(Duncan_fit,
          constraints = constrain_pairwise(":income", reg_ex = TRUE, with_zero = TRUE),
          vcov = "CR2", cluster = Duncan$cluster)

# Pairwise comparisons of type-by-education slopes, with two tests and 
# multiple comparisons p-value adjustment
Wald_test(Duncan_fit,
          constraints = constrain_pairwise(":education", reg_ex = TRUE),
          vcov = "CR2",
          cluster = Duncan$cluster,
          test = c("HTZ","chi-sq"),
          adjustment_method = "holm")

})

}
\seealso{
\code{\link{vcovCR}}, \code{\link{constrain_equal}},
  \code{\link{constrain_zero}}, \code{\link{constrain_pairwise}}
}
