\name{villalta_pts_score}
\alias{villalta_pts_score}
\title{
Villalta Score for Post-Thrombotic Syndrome (PTS)
}
\description{
Calculates the Villalta Score to diagnose and grade the severity of Post-Thrombotic Syndrome in patients with a history of Deep Vein Thrombosis (DVT). The score assesses 5 subjective symptoms and 6 objective clinical signs, each rated on a scale of 0 to 3. The presence of a venous ulcer automatically classifies the condition as severe.
}
\usage{
villalta_pts_score(pain, cramps, heaviness, paresthesia, pruritus,
                   pretibial_edema, skin_induration, hyperpigmentation,
                   redness, venous_ectasia, pain_on_calf_compression,
                   venous_ulcer_present)
}
\arguments{
  \item{pain}{
Numeric (0-3). Subjective rating of pain. (0=None, 1=Mild, 2=Moderate, 3=Severe).
}
  \item{cramps}{
Numeric (0-3). Subjective rating of cramps.
}
  \item{heaviness}{
Numeric (0-3). Subjective rating of heaviness.
}
  \item{paresthesia}{
Numeric (0-3). Subjective rating of paresthesia (pins and needles).
}
  \item{pruritus}{
Numeric (0-3). Subjective rating of pruritus (itching).
}
  \item{pretibial_edema}{
Numeric (0-3). Clinical sign of pretibial edema.
}
  \item{skin_induration}{
Numeric (0-3). Clinical sign of skin induration.
}
  \item{hyperpigmentation}{
Numeric (0-3). Clinical sign of hyperpigmentation.
}
  \item{redness}{
Numeric (0-3). Clinical sign of redness.
}
  \item{venous_ectasia}{
Numeric (0-3). Clinical sign of venous ectasia.
}
  \item{pain_on_calf_compression}{
Numeric (0-3). Clinical sign of pain on calf compression.
}
  \item{venous_ulcer_present}{
Numeric (0 or 1). Is a venous ulcer present? (1 = Yes). Note: Presence of an ulcer defines Severe PTS regardless of the numeric score.
}
}
\value{
A list containing:
\item{Villalta_Score}{The calculated total score (Sum of the 11 items).}
\item{Classification}{Severity classification (Absent, Mild, Moderate, Severe).}
}
\references{
Villalta S, Bagatella P, Piccioli A, et al. Assessment of validity and reproducibility of a clinical scale for the postthrombotic syndrome. Haemostasis. 1994;24(1):158a.
Kahn SR. Measurement of the postthrombotic syndrome. Wounds. 2009;21(11):304-309.
}
\examples{

# Example 1: Mild PTS
# Pain 1, Edema 1, others 0
villalta_pts_score(1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0)

# Example 2: Severe PTS due to Ulcer
# Score 10, Ulcer Present
villalta_pts_score(2, 2, 2, 1, 0, 1, 1, 1, 0, 0, 0, 1)
}
