\name{short_mast_alcohol_screen}
\alias{short_mast_alcohol_screen}
\title{
Short Michigan Alcoholism Screening Test (SMAST)
}
\description{
Calculates the SMAST score, a 13-item screening tool used to identify individuals with potential alcoholism. Each "Yes" response indicates a problem with alcohol use and contributes 1 point to the total score.
}
\usage{
short_mast_alcohol_screen(trouble_stopping_drinking, family_complain,
                          bad_feeling_past_week, needed_morning_drink,
                          friends_complain, neglected_obligations,
                          shakes_morning, memory_loss, medical_advice_reduce,
                          dui_arrest, history_hospitalization, help_for_drinking,
                          lost_friends_girl_boy)
}
\arguments{
  \item{trouble_stopping_drinking}{
Numeric (0 or 1). Do you feel you are a normal drinker? (Note: In standard SMAST, "No" to "Normal drinker" scores 1. Here, input 1 if problem/abnormal perception exists, or map accordingly. Assuming input reflects the "scored response" (1 = Yes to problem/No to normal)). Let's assume inputs are 1 for the "alcoholism-indicative" response.
}
  \item{family_complain}{
Numeric (0 or 1). Does your wife, husband, a parent, or other near relative ever worry or complain about your drinking? (1 = Yes).
}
  \item{bad_feeling_past_week}{
Numeric (0 or 1). Do you ever feel guilty about your drinking? (1 = Yes).
}
  \item{needed_morning_drink}{
Numeric (0 or 1). Do you ever feel the need to cut down on your drinking? (1 = Yes). (Note: Question text varies, but standard SMAST items align with these themes).
}
  \item{friends_complain}{
Numeric (0 or 1). Are you able to stop drinking when you want to? (If No -> 1 pt). (Input 1 if "Unable to stop").
}
  \item{neglected_obligations}{
Numeric (0 or 1). Have you ever neglected your family because of your use of alcohol? (1 = Yes).
}
  \item{shakes_morning}{
Numeric (0 or 1). Have you ever had the shakes in the morning after drinking? (1 = Yes).
}
  \item{memory_loss}{
Numeric (0 or 1). Have you ever had blackouts? (1 = Yes).
}
  \item{medical_advice_reduce}{
Numeric (0 or 1). Have you ever been told by a doctor to stop drinking? (1 = Yes).
}
  \item{dui_arrest}{
Numeric (0 or 1). Have you ever been arrested for driving under the influence of alcohol? (1 = Yes).
}
  \item{history_hospitalization}{
Numeric (0 or 1). Have you ever been in a hospital because of drinking? (1 = Yes).
}
  \item{help_for_drinking}{
Numeric (0 or 1). Have you ever gone to anyone for help about your drinking? (1 = Yes).
}
  \item{lost_friends_girl_boy}{
Numeric (0 or 1). Have you ever lost friends or girlfriends/boyfriends because of your drinking? (1 = Yes).
}
}
\value{
A list containing:
\item{SMAST_Score}{The calculated total score (Range 0-13).}
\item{Interpretation}{Classification (Low probability 0-1, Possible 2, Alcoholism >=3).}
}
\references{
Selzer ML, Vinokur A, van Rooijen L. A self-administered Short Michigan Alcoholism Screening Test (SMAST). J Stud Alcohol. 1975;36(1):117-126. doi:10.15288/jsa.1975.36.117
}
\examples{

# Example 1: High Probability
# Guilty (1), Family complains (1), Shakes (1)
# Score = 3
short_mast_alcohol_screen(0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0)

# Example 2: Low Probability
# No affirmative responses
short_mast_alcohol_screen(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
}
