\name{rome_iv_functional_gallbladder_disorder}
\alias{rome_iv_functional_gallbladder_disorder}
\title{
Rome IV Diagnostic Criteria for Functional Gallbladder Disorder
}
\description{
Evaluates the Rome IV diagnostic criteria for Functional Gallbladder Disorder (FGD), a functional biliary disorder characterized by pain of presumed biliary origin in the absence of gallstones or structural abnormality, and objective evidence of impaired gallbladder motility.
}
\usage{
rome_iv_functional_gallbladder_disorder(biliary_pain, normal_liver_enzymes,
                                        normal_pancreatic_enzymes, normal_imaging,
                                        low_ejection_fraction,
                                        not_explained_by_other_condition,
                                        symptom_onset_ge_6_months,
                                        symptoms_active_last_3_months)
}
\arguments{
  \item{biliary_pain}{
Numeric (0 or 1). Presence of recurrent episodes of biliary pain (pain in the epigastrium and/or right upper quadrant). (1 = Yes).
}
  \item{normal_liver_enzymes}{
Numeric (0 or 1). Is there documentation of normal liver enzymes (ALT/AST, ALP) and conjugated bilirubin? (1 = Yes).
}
  \item{normal_pancreatic_enzymes}{
Numeric (0 or 1). Is there documentation of normal pancreatic enzymes (amylase/lipase)? (1 = Yes).
}
  \item{normal_imaging}{
Numeric (0 or 1). Is there documentation of no gallstones or other structural pathology on transabdominal ultrasound? (1 = Yes).
}
  \item{low_ejection_fraction}{
Numeric (0 or 1). Is the gallbladder ejection fraction low (<38\% or site-specific abnormal cutoff) on cholecystokinin-stimulated scintigraphy (HIDA scan)? (1 = Yes).
}
  \item{not_explained_by_other_condition}{
Numeric (0 or 1). Are symptoms NOT fully explained by another medical condition (e.g., peptic ulcer disease, GERD, coronary artery disease)? (1 = Yes).
}
  \item{symptom_onset_ge_6_months}{
Numeric (0 or 1). Did symptom onset occur at least 6 months prior to diagnosis? (1 = Yes).
}
  \item{symptoms_active_last_3_months}{
Numeric (0 or 1). Have symptoms been active for the last 3 months? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Functional Gallbladder Disorder" or "Criteria Not Met".}
}
\references{
Corazziari E, Shaffer EA, Hogan WJ, et al. Functional Disorders of the Gallbladder and Sphincter of Oddi. Gastroenterology. 2016;150:1443-1455. doi:10.1053/j.gastro.2016.02.044
}
\examples{

# Example 1: Diagnosis Met
# All organic causes excluded, typical pain, and low EF documented
rome_iv_functional_gallbladder_disorder(1, 1, 1, 1, 1, 1, 1, 1)

# Example 2: Not Met (EF normal)
# All structural/lab criteria met, but EF is normal (0)
rome_iv_functional_gallbladder_disorder(1, 1, 1, 1, 0, 1, 1, 1)
}
