\name{rome_iv_child_aerophagia}
\alias{rome_iv_child_aerophagia}
\title{
Rome IV Diagnostic Criteria for Child Aerophagia
}
\description{
Evaluates the **Rome IV criteria** for diagnosing **Aerophagia** (excessive air swallowing) in children and adolescents. Diagnosis requires three key symptoms—excessive air swallowing, abdominal distention, and repetitive belching/flatus—at least 3 days per week, with symptom onset at least 6 months prior and active for the last 3 months, after excluding organic causes.
}
\usage{
rome_iv_child_aerophagia(symptom_frequency_ge_3_day_week,
                         excessive_air_swallowing, abdominal_distention,
                         repetitive_belching_flatus, not_explained_by_other_condition,
                         symptom_onset_ge_6_months, symptoms_active_last_3_months)
}
\arguments{
  \item{symptom_frequency_ge_3_day_week}{
Numeric (0 or 1). Does the symptom pattern occur at least 3 days per week? (1 = Yes).
}
  \item{excessive_air_swallowing}{
Numeric (0 or 1). Does the patient swallow excessive air? (1 = Yes).
}
  \item{abdominal_distention}{
Numeric (0 or 1). Is there abdominal distention due to intraluminal air? (1 = Yes).
}
  \item{repetitive_belching_flatus}{
Numeric (0 or 1). Is there repetitive belching and/or increased flatus? (1 = Yes).
}
  \item{not_explained_by_other_condition}{
Numeric (0 or 1). Are symptoms **NOT** fully explained by another medical condition (e.g., celiac disease, upper GI disease)? (1 = Yes).
}
  \item{symptom_onset_ge_6_months}{
Numeric (0 or 1). Did symptom onset occur at least **6 months ago**? (1 = Yes).
}
  \item{symptoms_active_last_3_months}{
Numeric (0 or 1). Have symptoms been active for the last **3 months**? (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{"Criteria Met for Aerophagia" or "Criteria Not Met".}
}
\references{
Hyams JS, Di Lorenzo C, Saps M, et al. Functional Disorders: Children and Adolescents. Gastroenterology. 2016;150:1456-1468. doi:10.1053/j.gastro.2016.02.015
}
\examples{

# Example 1: Diagnosis Met
# Frequency met (1), Air swallowing (1), Distention (1),
#Belching (1), No other cause (1), Chronic duration
rome_iv_child_aerophagia(1, 1, 1, 1, 1, 1, 1)

# Example 2: Not Met (Insufficient frequency)
# All criteria met except symptoms only 1 day/week (0)
rome_iv_child_aerophagia(0, 1, 1, 1, 1, 1, 1)
}
