\name{revised_trauma_score}
\alias{revised_trauma_score}
\title{
Revised Trauma Score (RTS)
}
\description{
Calculates the Revised Trauma Score (RTS), a physiological scoring system used to assess trauma severity. It provides two outputs: the Triage RTS (range 0-12, integer sum) for rapid field assessment, and the Standard RTS (range 0-7.8408, weighted sum) for outcome prediction and quality assurance.
}
\usage{
revised_trauma_score(gcs, systolic_bp, respiratory_rate)
}
\arguments{
  \item{gcs}{
Numeric. Glasgow Coma Scale score (3-15).
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg.
}
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute.
}
}
\details{
The coded values (0-4) for each parameter are assigned as follows:
\itemize{
  \item \strong{GCS}: 13-15 (4), 9-12 (3), 6-8 (2), 4-5 (1), 3 (0).
  \item \strong{SBP}: >89 (4), 76-89 (3), 50-75 (2), 1-49 (1), 0 (0).
  \item \strong{RR}: 10-29 (4), >29 (3), 6-9 (2), 1-5 (1), 0 (0).
}
The Standard RTS uses the formula: \eqn{RTS = 0.9368(GCS_c) + 0.7326(SBP_c) + 0.2908(RR_c)}.
}
\value{
A list containing:
\item{Triage_RTS}{Simple sum of coded values (0-12). Lower scores indicate higher severity.}
\item{Standard_RTS}{Weighted sum (0-7.8408). Higher scores indicate better probability of survival.}
\item{Coded_Values}{The intermediate 0-4 scores assigned to each input.}
}
\references{
Champion HR, Sacco WJ, Copes WS, et al. A revision of the Trauma Score. J Trauma. 1989;29(5):623-629.
}
\examples{

# Example 1: Stable Patient
# GCS 15 (4), SBP 120 (4), RR 16 (4)
# Triage RTS = 12, Standard RTS = 7.8408
revised_trauma_score(15, 120, 16)

# Example 2: Severe Trauma
# GCS 7 (2), SBP 80 (3), RR 35 (3)
# Standard RTS = 0.9368(2) + 0.7326(3) + 0.2908(3) = 1.8736 + 2.1978 + 0.8724 = 4.9438
revised_trauma_score(7, 80, 35)
}
