\name{prevail_prostate_cancer_survival}
\alias{prevail_prostate_cancer_survival}
\title{
PREVAIL Model for Prostate Cancer Survival
}
\description{
Calculates the Prognostic Index for patients with metastatic castration-resistant prostate cancer (mCRPC) based on the PREVAIL trial data (Armstrong et al., 2017). This model predicts overall survival in men treated with enzalutamide or placebo, utilizing 10 baseline clinical and laboratory factors.
}
\usage{
prevail_prostate_cancer_survival(albumin_g_l, alkaline_phosphatase_u_l,
                                 hemoglobin_g_dl, ldh_u_l,
                                 neutrophil_lymphocyte_ratio,
                                 bone_metastases_gt_10, visceral_disease,
                                 pain_score, psa_ng_ml, months_since_diagnosis)
}
\arguments{
  \item{albumin_g_l}{
Numeric. Serum Albumin level in g/L. (Note: Convert from g/dL if necessary by multiplying by 10).
}
  \item{alkaline_phosphatase_u_l}{
Numeric. Serum Alkaline Phosphatase (ALP) in U/L.
}
  \item{hemoglobin_g_dl}{
Numeric. Hemoglobin level in g/dL.
}
  \item{ldh_u_l}{
Numeric. Serum Lactate Dehydrogenase (LDH) in U/L.
}
  \item{neutrophil_lymphocyte_ratio}{
Numeric. Absolute Neutrophil Count divided by Absolute Lymphocyte Count (NLR).
}
  \item{bone_metastases_gt_10}{
Numeric (0 or 1). Are there more than 10 bone metastases? (1 = Yes).
}
  \item{visceral_disease}{
Numeric (0 or 1). Presence of visceral metastases (e.g., liver, lung). (1 = Yes).
}
  \item{pain_score}{
Numeric. Brief Pain Inventory-Short Form (BPI-SF) Item 3: "Rate your worst pain in the last 24 hours" (0-10).
}
  \item{psa_ng_ml}{
Numeric. Prostate Specific Antigen level in ng/mL.
}
  \item{months_since_diagnosis}{
Numeric. Time elapsed since the initial diagnosis of prostate cancer in months.
}
}
\value{
A list containing:
\item{Prognostic_Index}{The calculated linear predictor score.}
\item{Risk_Group}{General risk categorization based on the prognostic index.}
}
\references{
Armstrong AJ, Lin P, Tombal B, et al. Five-year Survival Prediction and Safety Outcomes with Enzalutamide in Men with Chemotherapy-naive Metastatic Castration-resistant Prostate Cancer from the PREVAIL Trial. Eur Urol. 2017;72(6):811-817. doi:10.1016/j.eururo.2017.07.035
}
\examples{
# Example 1: Low Risk Patient
# Alb 42 g/L, ALP 80, Hb 13.5, LDH 180, NLR 2.5, <10 Bone mets,
#No Visceral, Pain 1, PSA 15, 48 months since Dx
prevail_prostate_cancer_survival(42, 80, 13.5, 180, 2.5, 0, 0, 1, 15, 48)

# Example 2: High Risk Patient
# Alb 30 g/L, ALP 300, Hb 10.0, LDH 400, NLR 6.0, >10 Bone mets,
#Visceral Yes, Pain 6, PSA 150, 12 months since Dx
prevail_prostate_cancer_survival(30, 300, 10.0, 400, 6.0, 1, 1, 6, 150, 12)
}
