\name{possum_risk_score}
\alias{possum_risk_score}
\title{
POSSUM Score for Operative Morbidity and Mortality Risk
}
\description{
Calculates the Physiological and Operative Severity Score for the enUmeration of Mortality and morbidity (POSSUM). This system predicts the risk of morbidity and mortality in surgical patients based on 12 physiological and 6 operative factors.
}
\usage{
possum_risk_score(age, cardiac_signs, respiratory_signs, systolic_bp, pulse, gcs,
                  hemoglobin, wbc_count, urea, sodium, potassium, ecg_status,
                  operative_severity, multiple_procedures, total_blood_loss,
                  peritoneal_soiling, malignancy_status, mode_of_surgery,
                  urea_units = "mg/dL")
}
\arguments{
  \item{age}{Numeric. Patient age in years.}
  \item{cardiac_signs}{String. "normal", "mild" (diuretics/digoxin/angina/HTN), "moderate" (peripheral edema/warfarin), "severe" (raised JVP/cardiomegaly).}
  \item{respiratory_signs}{String. "normal", "mild" (dyspnea on exertion/COPD), "moderate" (limiting dyspnea), "severe" (dyspnea at rest/fibrosis).}
  \item{systolic_bp}{Numeric. Systolic blood pressure in mmHg.}
  \item{pulse}{Numeric. Pulse rate in bpm.}
  \item{gcs}{Numeric. Glasgow Coma Scale score (3-15).}
  \item{hemoglobin}{Numeric. Hemoglobin level in g/dL.}
  \item{wbc_count}{Numeric. White blood cell count in x10^9/L.}
  \item{urea}{Numeric. Blood Urea Nitrogen (BUN) or Urea.}
  \item{sodium}{Numeric. Serum Sodium in mmol/L.}
  \item{potassium}{Numeric. Serum Potassium in mmol/L.}
  \item{ecg_status}{String. "normal", "afib_mild" (AF rate 60-90), "abnormal_rhythm" (>4 ectopics/min, Q waves, ST changes).}
  \item{operative_severity}{String. "minor", "moderate", "major", "major_plus".}
  \item{multiple_procedures}{String. "1", "2", ">2".}
  \item{total_blood_loss}{Numeric. Total blood loss in mL.}
  \item{peritoneal_soiling}{String. "none", "minor" (serous fluid), "local_pus", "free_bowel_content" (or generalized pus/blood).}
  \item{malignancy_status}{String. "none", "primary" (primary only), "nodal" (nodal metastases), "distant" (distant metastases).}
  \item{mode_of_surgery}{String. "elective", "emergency_gt_24h" (resuscitation possible), "emergency_2_24h" (operation needed <24h), "emergency_lt_2h" (immediate surgery).}
  \item{urea_units}{String. "mg/dL" (default) or "mmol/L".}
}
\value{
A list containing:
\item{Physiological_Score}{The calculated physiological score (Range 12-88).}
\item{Operative_Severity_Score}{The calculated operative severity score (Range 6-48).}
\item{Predicted_Mortality_Risk}{Estimated percentage risk of mortality.}
\item{Predicted_Morbidity_Risk}{Estimated percentage risk of morbidity.}
}
\references{
Copeland GP, Jones D, Walters M. POSSUM: a scoring system for surgical audit. Br J Surg. 1991;78(3):355-360. doi:10.1002/bjs.1800780327
}
\examples{
possum_risk_score(
  age = 70,
  cardiac_signs = "mild",
  respiratory_signs = "normal",
  systolic_bp = 140,
  pulse = 80,
  gcs = 15,
  hemoglobin = 13.5,
  wbc_count = 8.0,
  urea = 20,
  sodium = 140,
  potassium = 4.2,
  ecg_status = "normal",
  operative_severity = "major",
  multiple_procedures = "1",
  total_blood_loss = 400,
  peritoneal_soiling = "none",
  malignancy_status = "primary",
  mode_of_surgery = "elective"
)
}
