\name{hestia_criteria}
\alias{hestia_criteria}
\title{
Hestia Criteria for Outpatient Pulmonary Embolism Treatment
}
\description{
Evaluates the Hestia Criteria to determine if a patient with acute Pulmonary Embolism (PE) is eligible for outpatient management. If *any* of the 11 criteria are met (Yes), the patient is generally considered ineligible for home treatment and should be admitted. If all criteria are negative (No), the patient may be considered low risk and suitable for outpatient care.
}
\usage{
hestia_criteria(hemodynamically_unstable, thrombolysis_needed, high_risk_bleeding,
                oxygen_needed_gt_24h, pe_on_anticoagulation, iv_pain_meds_needed,
                medical_social_reason, renal_failure, liver_failure, pregnancy,
                heparin_hit_history)
}
\arguments{
  \item{hemodynamically_unstable}{
Numeric (0 or 1). Is the patient hemodynamically unstable? (SBP < 100 mmHg with HR > 100 bpm, or requiring ICU care). (1 = Yes).
}
  \item{thrombolysis_needed}{
Numeric (0 or 1). Is thrombolysis or embolectomy necessary? (1 = Yes).
}
  \item{high_risk_bleeding}{
Numeric (0 or 1). Active bleeding or high risk of bleeding (e.g., GI bleed < 14 days, recent stroke < 4 weeks, recent surgery < 2 weeks, bleeding disorder, platelets < 75k). (1 = Yes).
}
  \item{oxygen_needed_gt_24h}{
Numeric (0 or 1). Oxygen supply needed to maintain SaO2 > 90% for more than 24 hours? (1 = Yes).
}
  \item{pe_on_anticoagulation}{
Numeric (0 or 1). Pulmonary embolism diagnosed while on anticoagulant treatment? (1 = Yes).
}
  \item{iv_pain_meds_needed}{
Numeric (0 or 1). Severe pain requiring IV pain medication for more than 24 hours? (1 = Yes).
}
  \item{medical_social_reason}{
Numeric (0 or 1). Medical or social reason for admission (e.g., infection, cancer, no support system at home)? (1 = Yes).
}
  \item{renal_failure}{
Numeric (0 or 1). Creatinine clearance < 30 mL/min? (1 = Yes).
}
  \item{liver_failure}{
Numeric (0 or 1). Severe liver impairment? (1 = Yes).
}
  \item{pregnancy}{
Numeric (0 or 1). Is the patient pregnant? (1 = Yes).
}
  \item{heparin_hit_history}{
Numeric (0 or 1). Documented history of Heparin-Induced Thrombocytopenia (HIT)? (1 = Yes).
}
}
\value{
A list containing:
\item{Hestia_Result}{Recommendation ("Eligible" vs "Not Eligible").}
\item{Criteria_Met_Count}{Number of positive criteria (0 required for eligibility).}
\item{Criteria_List}{List of specific exclusion criteria met.}
}
\references{
Zondag W, Mos IC, Creemers-Schild D, et al. Outpatient treatment in patients with acute pulmonary embolism: the Hestia Study. J Thromb Haemost. 2011;9(8):1500-1507. doi:10.1111/j.1538-7836.2011.04388.x
}
\examples{

# Example 1: Eligible for Outpatient
# All criteria No
hestia_criteria(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)

# Example 2: Ineligible (High Bleeding Risk)
# Bleeding risk = 1, others 0
hestia_criteria(0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0)
}
