\name{fomepizole_dosing}
\alias{fomepizole_dosing}
\title{
Fomepizole Dosing for Toxic Alcohol Ingestion
}
\description{
Calculates the recommended weight-based dosing regimen for Fomepizole (Antizol), an antidote used in confirmed or suspected ethylene glycol or methanol poisoning. The standard protocol involves a loading dose followed by maintenance doses, with specific frequency adjustments required during hemodialysis due to the drug's dialyzability.
}
\usage{
fomepizole_dosing(weight_kg, on_hemodialysis = 0)
}
\arguments{
  \item{weight_kg}{
Numeric. Patient's actual body weight in kilograms.
}
  \item{on_hemodialysis}{
Numeric (0 or 1). Is the patient currently undergoing or about to undergo hemodialysis? (1 = Yes, 0 = No). This alters the recommended dosing frequency.
}
}
\value{
A list containing:
\item{Weight_Used_kg}{The weight used for calculations.}
\item{Calculated_Dosing_Regimen}{A list detailing the Loading Dose, Maintenance Doses (Initial and Prolonged), and specific adjustments for dialysis if applicable.}
}
\references{
Antizol (fomepizole) [package insert]. Jazz Pharmaceuticals, Inc. Palo Alto, CA; 2021.
Brent J, McMartin K, Phillips S, et al. Fomepizole for the treatment of ethylene glycol poisoning. Methylpyrazole for Toxic Alcohols Study Group. N Engl J Med. 1999;340(11):832-838. doi:10.1056/NEJM199903183401102
}
\examples{

# Example 1: Standard Patient
# 70 kg, not on dialysis
fomepizole_dosing(70, 0)

# Example 2: Patient on Dialysis
# 80 kg, active hemodialysis
fomepizole_dosing(80, 1)
}
