\name{fast_ed_score}
\alias{fast_ed_score}
\title{
Field Assessment Stroke Triage for Emergency Destination (FAST-ED)
}
\description{
Calculates the FAST-ED score to identify stroke patients in the prehospital setting who are likely to have a Large Vessel Occlusion (LVO) and may benefit from direct transport to a Comprehensive Stroke Center for thrombectomy. The score evaluates facial palsy, arm weakness, speech changes, eye deviation, and denial/neglect.
}
\usage{
fast_ed_score(facial_palsy, arm_weakness, speech_changes, eye_deviation,
              denial_neglect)
}
\arguments{
  \item{facial_palsy}{
Numeric (0 or 1).
0: Normal or minor paralysis.
1: Partial or complete paralysis.
}
  \item{arm_weakness}{
Numeric (0, 1, or 2).
0: No drift.
1: Drift, or some effort against gravity.
2: No effort against gravity, or no movement.
}
  \item{speech_changes}{
Numeric (0, 1, or 2).
0: Absent.
1: Mild to moderate impairment.
2: Severe, global aphasia, or mute.
}
  \item{eye_deviation}{
Numeric (0, 1, or 2).
0: Absent.
1: Partial deviation.
2: Forced deviation.
}
  \item{denial_neglect}{
Numeric (0, 1, or 2). Extinction/Inattention.
0: Absent.
1: Extinction to one modality.
2: Extinction to both modalities.
}
}
\value{
A list containing:
\item{FAST_ED_Score}{The calculated total score (Range 0-9).}
\item{Likelihood}{Risk assessment for LVO (Score >= 4 suggests High Likelihood).}
\item{Recommendation}{Triage guidance for hospital destination.}
}
\references{
Lima FO, Silva GS, Furie KL, et al. Field Assessment Stroke Triage for Emergency Destination: A Simple and Accurate Prehospital Scale to Detect Large Vessel Occlusion Strokes. Stroke. 2016;47(8):1997-2002. doi:10.1161/STROKEAHA.116.013301
}
\examples{

# Example 1: High Probability of LVO
# Partial Face(1), No Arm Effort(2), Severe Speech(2), Forced Eyes(2), No Neglect(0)
# Score = 7
fast_ed_score(1, 2, 2, 2, 0)

# Example 2: Low Probability
# Minor Face(0), Arm Drift(1), Mild Speech(1), No Eyes(0), No Neglect(0)
# Score = 2
fast_ed_score(0, 1, 1, 0, 0)
}
