\name{edmonton_obesity_staging_system}
\alias{edmonton_obesity_staging_system}
\title{
Edmonton Obesity Staging System (EOSS)
}
\description{
Calculates the EOSS Stage to classify obesity based on the presence and severity of risk factors, comorbidities, and functional limitations. Unlike BMI, which measures size, EOSS measures the impact of obesity on health, guiding clinical management from prevention to palliative care.
}
\usage{
edmonton_obesity_staging_system(severe_functional_limitations, end_organ_damage,
                                established_comorbidity, subclinical_risk_factors)
}
\arguments{
  \item{severe_functional_limitations}{
Numeric (0 or 1). Presence of severe (end-stage) disabilities or severe psychopathology. (1 = Yes).
}
  \item{end_organ_damage}{
Numeric (0 or 1). Presence of established end-organ damage (e.g., myocardial infarction, heart failure, diabetic complications, stroke). (1 = Yes).
}
  \item{established_comorbidity}{
Numeric (0 or 1). Presence of established obesity-related chronic disease (e.g., hypertension, type 2 diabetes, sleep apnea, osteoarthritis) or moderate functional limitations. (1 = Yes).
}
  \item{subclinical_risk_factors}{
Numeric (0 or 1). Presence of subclinical risk factors (e.g., borderline hypertension, impaired fasting glucose, elevated liver enzymes) or mild physical symptoms. (1 = Yes).
}
}
\value{
A list containing:
\item{EOSS_Stage}{The calculated stage (0, 1, 2, 3, or 4).}
\item{Description}{Clinical definition of the stage.}
\item{Management_Recommendation}{Guideline-based management strategy.}
}
\references{
Sharma AM, Kushner RF. A proposed clinical staging system for obesity. Int J Obes (Lond). 2009;33(3):289-295. doi:10.1038/ijo.2009.2
}
\examples{

# Example 1: Stage 2 (Established Disease)
# Patient has Type 2 Diabetes and Hypertension, no end-organ damage
edmonton_obesity_staging_system(0, 0, 1, 1)

# Example 2: Stage 0 (Metabolically Healthy)
# No risk factors or symptoms identified
edmonton_obesity_staging_system(0, 0, 0, 0)
}
