\name{cryoprecipitate_dosing}
\alias{cryoprecipitate_dosing}
\title{
Cryoprecipitate Dosing for Fibrinogen Replacement
}
\description{
Calculates the number of cryoprecipitate units required to raise a patient's serum fibrinogen level to a specified target. The calculation estimates the patient's plasma volume based on weight and hematocrit, determines the total fibrinogen deficit, and divides by the average fibrinogen content per unit of cryoprecipitate.
}
\usage{
cryoprecipitate_dosing(current_fibrinogen, target_fibrinogen, weight_kg,
                       hematocrit, fibrinogen_per_unit_mg = 250)
}
\arguments{
  \item{current_fibrinogen}{
Numeric. Current serum fibrinogen level in mg/dL.
}
  \item{target_fibrinogen}{
Numeric. Desired serum fibrinogen level in mg/dL (typically 100-150 mg/dL depending on clinical scenario).
}
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
  \item{hematocrit}{
Numeric. Patient hematocrit percentage (e.g., 40 for 40\%). Used to estimate plasma volume.
}
  \item{fibrinogen_per_unit_mg}{
Numeric. The estimated amount of fibrinogen in a single unit of cryoprecipitate. Defaults to 250 mg (common range 200-250 mg, but can vary by blood bank).
}
}
\value{
A list containing:
\item{Estimated_Units}{The calculated number of units needed, rounded up to the nearest whole unit.}
\item{Exact_Units_Calculation}{The raw calculated dosage value.}
\item{Total_Fibrinogen_Required_mg}{The total milligrams of fibrinogen required to meet the deficit.}
\item{Plasma_Volume_dL}{The estimated plasma volume used in the calculation.}
}
\references{
Nickson C. Cryoprecipitate. Life in the Fast Lane (LITFL). 2020.
Guidelines for the use of fresh-frozen plasma, cryoprecipitate and cryosupernatant. British Committee for Standards in Haematology. Br J Haematol. 2004;126(1):11-28.
}
\examples{

# Example 1: 70kg patient, Hct 40, Fib 50, Target 100
# TBV = 4900 mL, PV = 2940 mL (29.4 dL)
# Deficit = 50 mg/dL * 29.4 dL = 1470 mg
# Units (at 250mg/unit) = 5.88 -> 6 Units
cryoprecipitate_dosing(50, 100, 70, 40)

# Example 2: 80kg patient, Hct 30, Fib 100, Target 150 (Higher target)
cryoprecipitate_dosing(100, 150, 80, 30)
}
