\name{canadian_ct_head_rule}
\alias{canadian_ct_head_rule}
\title{
Canadian CT Head Rule
}
\description{
Applies the Canadian CT Head Rule (CCHR) to determine the need for computed tomography (CT) imaging in patients with minor head injury. It stratifies patients into High Risk (requiring neurological intervention), Medium Risk (risk of brain injury on CT), and Low Risk (CT not indicated). The rule is applicable to patients with GCS 13-15 and loss of consciousness, amnesia, or confusion.
}
\usage{
canadian_ct_head_rule(gcs_less_than_15_at_2h, suspected_open_skull_fracture,
                      basal_skull_fracture_signs, vomiting_ge_2, age,
                      amnesia_pre_impact_gt_30m, dangerous_mechanism)
}
\arguments{
  \item{gcs_less_than_15_at_2h}{
Numeric (0 or 1). Glasgow Coma Scale score < 15 at 2 hours post-injury. (1 = Yes).
}
  \item{suspected_open_skull_fracture}{
Numeric (0 or 1). Suspected open or depressed skull fracture. (1 = Yes).
}
  \item{basal_skull_fracture_signs}{
Numeric (0 or 1). Any sign of basal skull fracture (hemotympanum, raccoon eyes, CSF otorrhea/rhinorrhea, Battle's sign). (1 = Yes).
}
  \item{vomiting_ge_2}{
Numeric (0 or 1). Vomiting >= 2 episodes. (1 = Yes).
}
  \item{age}{
Numeric. Patient age in years. (>= 65 years is High Risk).
}
  \item{amnesia_pre_impact_gt_30m}{
Numeric (0 or 1). Retrograde amnesia to the event > 30 minutes. (1 = Yes).
}
  \item{dangerous_mechanism}{
Numeric (0 or 1). Dangerous mechanism of injury (Pedestrian struck by vehicle, occupant ejected, fall from >3 ft or 5 stairs). (1 = Yes).
}
}
\value{
A list containing:
\item{Risk_Level}{"High Risk", "Medium Risk", or "Low Risk".}
\item{Recommendation}{"CT Head is indicated" or "CT Head not indicated".}
\item{Reasoning}{Explanation of the risk based on intervention need or injury findings.}
}
\references{
Stiell IG, Wells GA, Vandemheen K, et al. The Canadian CT Head Rule for patients with minor head injury. Lancet. 2001;357(9266):1391-1396. doi:10.1016/s0140-6736(00)04561-x
}
\examples{

# Example 1: High Risk (Age)
# 70yo, no other symptoms
canadian_ct_head_rule(0, 0, 0, 0, 70, 0, 0)

# Example 2: Medium Risk (Dangerous Mechanism)
# 30yo, Fall from >3ft, GCS 15
canadian_ct_head_rule(0, 0, 0, 0, 30, 0, 1)

# Example 3: Low Risk
# 25yo, Minor fall, no amnesia/vomiting
canadian_ct_head_rule(0, 0, 0, 0, 25, 0, 0)
}
