\name{bap65_copd}
\alias{bap65_copd}
\title{
BAP-65 Score for Acute Exacerbation of COPD
}
\description{
Calculates the BAP-65 score to stratify risk in patients presenting with an acute exacerbation of Chronic Obstructive Pulmonary Disease (COPD). The score correlates with in-hospital mortality and need for mechanical ventilation.
}
\usage{
bap65_copd(bun, altered_mental_status, pulse, age)
}
\arguments{
  \item{bun}{
Numeric. Blood Urea Nitrogen in mg/dL. (>= 25 mg/dL adds +1 point).
}
  \item{altered_mental_status}{
Numeric (0 or 1). Presence of altered mental status (GCS <= 14 or disorientation). (1 = Yes, +1 point).
}
  \item{pulse}{
Numeric. Heart rate in bpm. (>= 109 bpm adds +1 point).
}
  \item{age}{
Numeric. Patient age in years. (> 65 years adds +1 point).
}
}
\value{
A list containing:
\item{BAP65_Score}{The calculated score (Range 0-4).}
\item{Risk_Class}{Classification (Class I to IV).}
\item{In_Hospital_Mortality}{Estimated in-hospital mortality risk.}
\item{Recommendation}{Clinical guidance regarding disposition (discharge, ward, or ICU).}
}
\references{
Shorr AF, Sun X, Johannes RS, Yaitanes A, Tabak YP. Validation of a novel risk score for severity of illness in acute exacerbations of COPD. Chest. 2011;140(5):1177-1183. doi:10.1378/chest.10-2851
}
\examples{

# Example 1: High Risk (Class IV)
# BUN 30 (+1), Alert (0), Pulse 115 (+1), Age 70 (+1)
# Score = 3
bap65_copd(30, 0, 115, 70)

# Example 2: Low Risk (Class I)
# BUN 15 (0), Alert (0), Pulse 80 (0), Age 60 (0)
# Score = 0
bap65_copd(15, 0, 80, 60)
}
