\name{aub_has2_cardiovascular_risk}
\alias{aub_has2_cardiovascular_risk}
\title{
American University of Beirut (AUB) HAS2 Cardiovascular Risk Index
}
\description{
Calculates the AUB-HAS2 score to stratify cardiovascular risk. This simple additive risk index was derived and validated to predict major adverse cardiovascular events (death, myocardial infarction, or coronary revascularization) using four easily obtainable clinical variables: Hypertension, Age, Smoking, and Hyperlipidemia (HAS2).
}
\usage{
aub_has2_cardiovascular_risk(hypertension, age, smoking, hyperlipidemia)
}
\arguments{
  \item{hypertension}{
Numeric (0 or 1). History of Hypertension. (1 = Yes, +1 point).
}
  \item{age}{
Numeric. Patient age in years. (>= 60 years adds +1 point).
}
  \item{smoking}{
Numeric (0 or 1). Current or recent smoker (< 1 year). (1 = Yes, +1 point).
}
  \item{hyperlipidemia}{
Numeric (0 or 1). History of Hyperlipidemia or Dyslipidemia. (1 = Yes, +2 points).
}
}
\value{
A list containing:
\item{Total_Score}{The calculated AUB-HAS2 score (Range 0-5).}
\item{Risk_Category}{Risk classification (Low: 0-1, Intermediate: 2, High: >=3).}
}
\references{
Dakik HA, Chehab O, Eldanawi H, et al. The AUB-HAS2 Cardiovascular Risk Index: A Simple Outcome Score for Clinical Practice. PLoS One. 2016;11(1):e0146534. doi:10.1371/journal.pone.0146534
}
\examples{

# Example 1: High Risk
# Hypertension (+1), Age 65 (+1), Hyperlipidemia (+2) -> Score 4
aub_has2_cardiovascular_risk(1, 65, 0, 1)

# Example 2: Low Risk
# Smoking only (+1), Age 40, No HTN/Lipids
# Score = 1
aub_has2_cardiovascular_risk(0, 40, 1, 0)
}
