\name{atropine_toxicity_dosing}
\alias{atropine_toxicity_dosing}
\title{
Atropine Dosing for Cholinesterase Inhibitor Toxicity
}
\description{
Calculates the recommended atropine dosing for patients with organophosphate or carbamate toxicity (cholinesterase inhibitor poisoning). The protocol utilizes a "doubling dose" strategy: if bronchial secretions remain copious after the initial dose, the subsequent dose is doubled every 5-10 minutes until secretions are dried (atropinization). Once controlled, a maintenance infusion is calculated.
}
\usage{
atropine_toxicity_dosing(last_dose_mg, secretions_controlled,
                         total_cumulative_dose_mg = NULL)
}
\arguments{
  \item{last_dose_mg}{
Numeric. The amount of atropine (in mg) administered in the most recent bolus.
}
  \item{secretions_controlled}{
Numeric (0 or 1). Assessment of therapeutic endpoint (clear breath sounds, dry axillae, no bronchorrhea). (1 = Yes, 0 = No).
}
  \item{total_cumulative_dose_mg}{
Numeric (Optional). The total sum of all bolus doses administered to achieve control. Required to calculate the maintenance infusion rate (typically 10-20\% of the total loading dose per hour).
}
}
\value{
A list containing:
\item{Status}{Current clinical status (Controlled vs. Uncontrolled).}
\item{Recommendation}{Clinical action plan (Double dose or Start infusion).}
\item{Next_Bolus_Dose_mg}{The recommended quantity for the next IV push if uncontrolled.}
\item{Maintenance_Infusion_Rate}{The recommended hourly infusion rate if controlled.}
}
\references{
Eddleston M, Buckley NA, Eyer P, Dawson AH. Management of acute organophosphorus pesticide poisoning. Lancet. 2008;371(9612):597-607. doi:10.1016/S0140-6736(07)61202-1
}
\examples{

# Example 1: Uncontrolled after 2mg
# Secretions still present (0)
atropine_toxicity_dosing(2, 0)

# Example 2: Uncontrolled after 4mg
# Secretions still present (0) -> Recommends 8mg
atropine_toxicity_dosing(4, 0)

# Example 3: Controlled
# Secretions dry (1). Total dose given was 20mg.
# Recommends infusion at 2-4 mg/hr
atropine_toxicity_dosing(8, 1, total_cumulative_dose_mg = 20)
}
