\name{astral_stroke_score}
\alias{astral_stroke_score}
\title{
ASTRAL Score for Ischemic Stroke
}
\description{
Calculates the ASTRAL (Acute Stroke Registry and Analysis of Lausanne) Score to predict the probability of an unfavorable functional outcome (modified Rankin Scale score > 2) at 3 months following an acute ischemic stroke.
}
\usage{
astral_stroke_score(age, nihss, time_gt_3h, visual_field_defect, glucose,
                    loc_reduced, glucose_units = "mg/dL")
}
\arguments{
  \item{age}{
Numeric. Patient age in years. (Score adds 1 point for every 5 years).
}
  \item{nihss}{
Numeric. Admission NIH Stroke Scale score (0-42). (Score adds 1 point for every 1 NIHSS point).
}
  \item{time_gt_3h}{
Numeric (0 or 1). Time from symptom onset to admission > 3 hours. (1 = Yes, +2 points).
}
  \item{visual_field_defect}{
Numeric (0 or 1). Presence of any visual field defect (from NIHSS item 3). (1 = Yes, +2 points).
}
  \item{glucose}{
Numeric. Admission blood glucose level. (> 131 mg/dL or > 7.3 mmol/L adds +1 point).
}
  \item{loc_reduced}{
Numeric (0 or 1). Reduced level of consciousness (NIHSS item 1a > 0). (1 = Yes, +2 points).
}
  \item{glucose_units}{
String. Units for glucose input. Options: "mg/dL" (default) or "mmol/L".
}
}
\value{
A list containing:
\item{ASTRAL_Score}{The calculated integer score.}
\item{Unfavorable_Outcome_Probability_3mo}{Estimated percentage probability of death or dependency (mRS 3-6) at 3 months.}
}
\references{
Ntaios G, Faouzi M, Ferrari J, et al. An integer-based score to predict functional outcome in acute ischemic stroke: the ASTRAL score. Neurology. 2012;78(24):1916-1922. doi:10.1212/WNL.0b013e318259e221
}
\examples{

# Example 1: High Risk
# 80yo (16pts), NIHSS 20, Time >3h (2), Visual Defect (2), Glucose 150 (1), Reduced LOC (2)
# Score = 16 + 20 + 2 + 2 + 1 + 2 = 43
astral_stroke_score(80, 20, 1, 1, 150, 1)

# Example 2: Moderate Risk
# 65yo (13pts), NIHSS 8, Time <3h (0), No Visual (0), Glucose 100 (0), Alert LOC (0)
# Score = 13 + 8 = 21
astral_stroke_score(65, 8, 0, 0, 100, 0)
}
