% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctsem.R
\name{ctsem.alpha}
\alias{ctsem.alpha}
\alias{ctsem.split}
\title{Standard error of measurement (SEM)}
\usage{
ctsem.alpha(x, wt = NULL, administered = NULL, maxscore = NULL)

ctsem.split(
  x,
  wt = NULL,
  tries = 100,
  seed = NA,
  administered = NULL,
  maxscore = NULL
)
}
\arguments{
\item{x}{a data frame or matrix of scored data.}

\item{wt}{a vector with total weights. Default is \code{NULL}.}

\item{administered}{a logical matrix indicating which items were administered.
The dimensions should be the same as \code{x}. If \code{NULL} all items
are considered administered.}

\item{maxscore}{a numeric value indicating which is the maximum score possible
per item. The minimum score is assumed to be 0. If \code{NULL} the maximum score is assumed to be
derived from the maximum value found in \code{x} or 1 if \code{x} only has 0s.}

\item{tries}{a numeric value indicating the number of samples for the
split-halves coefficient. Default is \code{100}.}

\item{seed}{a single value, interpreted as an integer, or \code{NULL}
    (see \sQuote{Details}).}
}
\value{
a list.
}
\description{
Estimates the standard error of measurement (SEM) of a scored matrix or
data frame using Cronbach's alpha or the split-halves coefficient.
}
\examples{
# No weights
ex <- correct(x = dichodata, key = dichokey, navalue = NA)
ctsem.alpha(ex)
ctsem.split(ex,tries = 5)


# With weights
set.seed(1919)
wt <- sample(x = 1:4, size = nrow(dichodata), replace = TRUE)
ctsem.alpha(ex,wt = wt)
ctsem.split(ex,wt = wt,tries = 5)

}
\keyword{stats}
