% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task_graph.R
\name{task_graph_update_ready}
\alias{task_graph_update_ready}
\title{Find the Next Packages Not Dependent on an Unavailable Package}
\usage{
task_graph_update_ready(
  g,
  v = V(g),
  dependencies = TRUE,
  status = STATUS$pending
)
}
\arguments{
\item{g}{A dependency graph, as produced with \code{\link[=task_graph]{task_graph()}}.}

\item{v}{Names or nodes objects of packages whose satisfiability should be
checked.}

\item{dependencies}{Which dependencies types should be met for a node to be
considered satisfied.}

\item{status}{status name. Nodes in v fill be filtered to consists only nodes
with that status.}
}
\value{
The name of the next package to prioritize
}
\description{
While other packages are in progress, ensure that the next selected package
already has its dependencies done.
}
\details{
There are helpers defined for particular use cases that strictly rely on the
\code{\link[=task_graph_which_ready]{task_graph_which_ready()}}, they are:
\itemize{
\item \code{task_graph_update_check_ready()} - Updates check vertices whose all
dependencies are satisfied.
\item \code{task_graph_update_install_ready()} - Update install vertices whose all
dependencies are satisfied.
\item \code{task_graph_which_ready()} - List vertices whose wit ready status.
}
}
\keyword{internal}
