% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task_graph.R
\name{task_graph}
\alias{task_graph}
\title{Build task graph edges}
\usage{
task_graph(x, repos = getOption("repos"), ...)
}
\arguments{
\item{x}{a \code{plan} object, containing a list of related steps.}

\item{repos}{\code{repos}, as expected by \code{\link[tools:package_dependencies]{tools::package_dependencies()}} to
determine package relationships.}

\item{...}{params passed to helper methods.}
}
\value{
A \code{data.frame} that can be used to build
\code{\link[igraph:make_graph]{igraph::make_graph}} edges.
}
\description{
Edges describe relationships between tasks. Often, this is a dependency
between packages, requiring that some package be installed before a latter
task can be executed.
}
\details{
\code{\link[tools:package_dependencies]{tools::package_dependencies()}} is used to calculate these relationships.
However, the package data returned by \code{\link[utils:available.packages]{utils::available.packages()}},
that is used internally to determine dependencies does not know about
local or remote packages, so those are first appended to this data set
prior to calculating edges. The bulk of this function serves to join this
data.
}
\examples{
\dontrun{
task_graph(plan_rev_dep_checks("."))
}
}
\keyword{internal}
