% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knowledge-verbs.R
\name{seq_tiers}
\alias{seq_tiers}
\title{Generate a Bundle of Tier–Variable Formulas}
\usage{
seq_tiers(tiers, vars)
}
\arguments{
\item{tiers}{An integer vector of tier indices (each >= 1). These will appear as the
left‐hand sides of the generated formulas.}

\item{vars}{A tidyselect specification (unevaluated) that \emph{must} contain the special
placeholder \code{i}, either as the symbol \code{i} or inside a string
like \code{"…{i}…"}.  For each value of \code{i} in \code{tiers}, that
placeholder will be substituted and the resulting call used as the
right‐hand side of a formula.}
}
\value{
A list of two‐sided formulas, each of class \code{"tier_bundle"}.
You can pass this list directly to \code{tier()} (which will expand it
automatically).
}
\description{
Quickly create a series of two‐sided formulas for use with \code{tier()},
where each formula maps a numeric tier index to a tidyselect specification
that contains the placeholder \code{i}.  The placeholder \code{i} is replaced
by each element of \code{tiers} in turn, allowing you to write a single
template rather than many nearly identical formulas.
}
\examples{
# generate a bundle of tier formulas using a pattern with {i}
# here we create: 1 ~ matches("^child_x1$"), 2 ~ matches("^child_x2$")
data(tpc_example)

kn <- knowledge(
  tpc_example,
  tier(seq_tiers(1:2, matches("^child_x{i}$")))
)
print(kn)
}
\seealso{
Other knowledge functions: 
\code{\link{+.Knowledge}()},
\code{\link{add_exogenous}()},
\code{\link{add_tier}()},
\code{\link{add_to_tier}()},
\code{\link{add_vars}()},
\code{\link{as_bnlearn_knowledge}()},
\code{\link{as_pcalg_constraints}()},
\code{\link{as_tetrad_knowledge}()},
\code{\link{convert_tiers_to_forbidden}()},
\code{\link{deparse_knowledge}()},
\code{\link{forbid_edge}()},
\code{\link{get_tiers}()},
\code{\link{knowledge}()},
\code{\link{knowledge_to_caugi}()},
\code{\link{remove_edge}()},
\code{\link{remove_tiers}()},
\code{\link{remove_vars}()},
\code{\link{reorder_tiers}()},
\code{\link{reposition_tier}()},
\code{\link{require_edge}()},
\code{\link{unfreeze}()}
}
\concept{knowledge}
\concept{knowledge functions}
