% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disco-class.R
\name{print.Disco}
\alias{print.Disco}
\title{Print a Disco Object}
\usage{
\method{print}{Disco}(x, compact = FALSE, wide_vars = FALSE, ...)
}
\arguments{
\item{x}{A \code{Disco} object.}

\item{compact}{Logical. If \code{TRUE}, prints a more compact summary.}

\item{wide_vars}{Logical. If \code{TRUE}, prints the variables in a wide format.}

\item{...}{Additional arguments (not used).}
}
\value{
Invisibly returns the \code{Disco} object.
}
\description{
Print a Disco Object
}
\examples{
data(tpc_example)
kn <- knowledge(
  tpc_example,
  tier(
    child ~ starts_with("child"),
    youth ~ starts_with("youth"),
    old ~ starts_with("old")
  )
)
cd_tges <- tpc(engine = "causalDisco", test = "fisher_z")
disco_cd_tges <- disco(data = tpc_example, method = cd_tges, knowledge = kn)
print(disco_cd_tges)
print(disco_cd_tges, wide_vars = TRUE)
print(disco_cd_tges, compact = TRUE)

}
