% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/julian.R
\name{julian_date}
\alias{julian_date}
\alias{as_julian}
\title{Julian calendar dates}
\usage{
julian_date(year = integer(), month = integer(), day = integer())

as_julian(date)
}
\arguments{
\item{year}{A numeric vector of years}

\item{month}{A numeric vector of months}

\item{day}{A numeric vector of days}

\item{date}{Vector of dates on some calendar}
}
\value{
A julian vector object
}
\description{
The Julian calendar is the calendar used by the Roman Empire, and
takes its name from Julius Caesar, who introduced it in 46 BC. It
is still used as a religious calendar in parts of the Eastern
Orthodox Church.
}
\examples{
as_date("2016-01-01", calendar = cal_julian)
as_date(Sys.Date(), calendar = cal_julian)
tibble::tibble(
  x = seq(as.Date("2025-01-01"), as.Date("2025-12-31"), by = "day"),
  y = as_date(x, calendar = cal_gregorian),
  z = as_date(x, calendar = cal_julian)
)
new_date(year = 2025, month = 4, day = 19:30, calendar = cal_julian)
julian_date(2025, 4, 19:30)
as_julian("2016-01-01")
as_julian(Sys.Date())
tibble::tibble(
  x = seq(as.Date("2025-01-01"), as.Date("2025-12-31"), by = "day"),
  y = as_julian(x)
)
}
\seealso{
\link{cal_julian}
}
