% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-web.R
\name{btw_tool_web_read_url}
\alias{btw_tool_web_read_url}
\title{Tool: Read a Web Page as Markdown}
\usage{
btw_tool_web_read_url(url, `_intent` = "")
}
\arguments{
\item{url}{The URL of the web page to read.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
Returns a \code{BtwWebPageResult} object that inherits from
\link[ellmer:Content]{ellmer::ContentToolResult} containing the markdown content of the web
page.
}
\description{
Tool: Read a Web Page as Markdown
}
\details{
You can control the maximum time to wait for the page to load by setting
the \code{btw.max_wait_for_page_load_s} option globally in your R session.
}
\examples{
\dontshow{if (rlang::is_installed("chromote") && rlang::is_interactive()) withAutoprint(\{ # examplesIf}
btw_tool_web_read_url("https://www.r-project.org/")
btw_tool_web_read_url(
  "https://posit.co/blog/easy-tool-calls-with-ellmer-and-chatlas/"
)
\dontshow{\}) # examplesIf}
}
\concept{web tools}
