% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-git.R
\name{btw_tool_git_log}
\alias{btw_tool_git_log}
\title{Tool: Git Log}
\usage{
btw_tool_git_log(ref = "HEAD", max = 10, after = NULL, `_intent` = "")
}
\arguments{
\item{ref}{Revision string with a branch/tag/commit value. Defaults to
\code{"HEAD"}.}

\item{max}{Maximum number of commits to retrieve. Defaults to 10.}

\item{after}{Optional date or timestamp: only include commits after this
date.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
Returns a character table of commit history.
}
\description{
This tool allows an LLM to run \code{\link[gert:git_commit]{gert::git_log()}}, equivalent to \verb{git log} in
the terminal, and to see the commit history of a repository.
}
\examples{
\dontshow{if (rlang::is_installed("gert")) withAutoprint(\{ # examplesIf}
withr::with_tempdir({
  gert::git_init()
  gert::git_config_set("user.name", "R Example")
  gert::git_config_set("user.email", "ex@example.com")

  writeLines("hello, world", "hello.md")
  gert::git_add("hello.md")
  gert::git_commit("Initial commit")

  writeLines("hello, universe", "hello.md")
  gert::git_add("hello.md")
  gert::git_commit("Update hello.md")

  # What the LLM sees
  cat(btw_tool_git_log()@value)
})
\dontshow{\}) # examplesIf}
}
\seealso{
Other git tools: 
\code{\link{btw_tool_git_branch_checkout}()},
\code{\link{btw_tool_git_branch_create}()},
\code{\link{btw_tool_git_branch_list}()},
\code{\link{btw_tool_git_commit}()},
\code{\link{btw_tool_git_diff}()},
\code{\link{btw_tool_git_status}()}
}
\concept{git tools}
