# Generated by roxytest: do not edit by hand!

# File R/"08-compare.R": @testexamples

test_that("Function br_compare_models() @ L62", {
  
  # Compare univariate vs multivariate for Cox models
  lung <- survival::lung |>
    dplyr::filter(ph.ecog != 3)
  lung$ph.ecog <- factor(lung$ph.ecog)
  
  comparison <- br_compare_models(
    lung,
    y = c("time", "status"),
    x = c("ph.ecog", "ph.karno", "pat.karno"),
    x2 = c("age", "sex"),
    method = "coxph"
  )
  
  # View combined results
  comparison$combined_results_tidy
  
  # Create forest plot comparison
  br_show_forest_comparison(comparison)
  expect_s3_class(comparison, "breg_comparison")
  expect_true("mode" %in% colnames(comparison$combined_results_tidy))
})


test_that("Function br_show_forest_comparison() @ L270", {
  
  lung <- survival::lung |>
    dplyr::filter(ph.ecog != 3)
  lung$ph.ecog <- factor(lung$ph.ecog)
  
  comparison <- br_compare_models(
    lung,
    y = c("time", "status"),
    x = c("ph.ecog", "ph.karno", "pat.karno"),
    x2 = c("age", "sex"),
    method = "coxph"
  )
  
  br_show_forest_comparison(comparison)
  expect_s3_class(br_show_forest_comparison(comparison), "forestplot")
})

