% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08-compare.R
\name{br_show_forest_comparison}
\alias{br_show_forest_comparison}
\title{Show forest plot for model comparison}
\usage{
br_show_forest_comparison(comparison, ..., xlim = NULL, rm_controls = TRUE)
}
\arguments{
\item{comparison}{A \code{breg_comparison} object from \code{\link[=br_compare_models]{br_compare_models()}}.}

\item{...}{Additional arguments passed to \code{\link[forestploter:forest]{forestploter::forest()}}.}

\item{xlim}{Numeric vector of length 2 specifying x-axis limits.}

\item{rm_controls}{If \code{TRUE}, show only focal variables (default).}
}
\value{
A forest plot object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Creates a forest plot comparing univariate and multivariate model results
side by side. Each variable shows estimates from both modeling approaches.
}
\examples{
lung <- survival::lung |>
  dplyr::filter(ph.ecog != 3)
lung$ph.ecog <- factor(lung$ph.ecog)

comparison <- br_compare_models(
  lung,
  y = c("time", "status"),
  x = c("ph.ecog", "ph.karno", "pat.karno"),
  x2 = c("age", "sex"),
  method = "coxph"
)

br_show_forest_comparison(comparison)
}
\seealso{
Other br_compare: 
\code{\link{br_compare_models}()}
}
\concept{br_compare}
