% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bs_prep_and_analysis.R
\name{bs_prep_and_analysis}
\alias{bs_prep_and_analysis}
\title{Load data associated with the spiked samples and laboratory results
from comma separated variable text files.}
\usage{
bs_prep_and_analysis(spike_data, lab_data)
}
\arguments{
\item{spike_data}{name of the loaded dataset (no quotes) or the name
of the file, with path, containing the spike values, in quotes.
Example forms, my_spike_data, or "C:/my_directory/my_spike_data.csv".
This file column headings must be as identified in the Details section.}

\item{lab_data}{name of the loaded dataset (no quotes) or the name
of the file, with path, containing the laboratory results.
Example forms, my_lab_data, or "C:/my_directory/my_lab_data.csv".
This file column headings must be as identified in the Details section.}
}
\value{
data frame containing all needed data to be used in subsequent
functions.
}
\description{
This function loads spike data and the laboratory results, then processes
it so that the `sample_ID` ties the spike value and the results together,
using the `left_join` function from the `dplyr` package.
}
\details{
False negative results are flagged for laboratory results below the detection
level in the analysis of a sample spiked above the detection level.
False positives are flagged for laboratory results above the detection when
the analyte was not spiked. Error rates are computed with the `table_false`
function.

To use this function, first set up spike value data in a .csv file
(in any column order) matching the column headers of the following values:

Required for spike data:
\itemize{
\item `sample_ID` unique identifier, character or numeric
\item `analyte` character data
\item `spike_value` numeric value
\item `spike_units` character data
\item `submission_date` character data that will be converted to date in format
 YYYY-MM-DD (for example 1999-12-31)
 }

Optional for spike data:
\itemize{
\item `sv_unc` numeric, the uncertainty of the spike value. Default = 0
\item `sv_k` the coverage factor for the spike value uncertainty. Default = 2
\item `provider lab` character name of laboratory providing spiked samples
}

Required for laboratory results:
\itemize{
\item `sample_ID` must match spike `sample_ID`
\item `analyte` must match spike `analyte`
\item `result` numeric value
\item `units` must match `spike_units`
\item `result_date`
\item `det_lvl` numeric detection level
\item `unc` numeric uncertainty of the laboratory result
}

#' Optional for lab data:
\itemize{
\item `k` the coverage factor for the result uncertainty. Default = 2
}
Note that the two data sets (spike values and laboratory results) will
be combined by `sample_ID`, and also by `analyte` if present in both sets.
(If the laboratory data includes a non-zero result for an analyte not
present in the spike data, that would indicate a false positive.)

Use this function to load the spike data and establish a data frame named
`bs_df`. All plotting and data analysis functions will default to look for
this data set.
}
\examples{
example_spike_data <- system.file("extdata", "spikevals.csv", package = "blindspiker")
example_lab_data <- system.file("extdata", "labvals.csv", package = "blindspiker")
example_df <- bs_prep_and_analysis(spike_data = example_spike_data, lab_data = example_lab_data)

}
