% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_group_trajectory_2d.R
\name{plot_group_trajectories_2d}
\alias{plot_group_trajectories_2d}
\title{Visualize 2D Technological Trajectories from Group Evolution}
\usage{
plot_group_trajectories_2d(
  groups_cumulative_trajectories,
  group = "c1g1",
  jaccard_similarity = 0.01,
  prop_tracked_intra_group_treshold = 0.2,
  label_type = "size",
  label_vertical_position = 0,
  label_horizontal_position = 0,
  label_angle = 0,
  time_span = NA,
  show_legend = TRUE
)
}
\arguments{
\item{groups_cumulative_trajectories}{A list with components
\code{groups_similarity} and \code{groups_attributes}, typically produced by
\code{plot_groups_trajectories()}. The \code{groups_similarity} element must be
a named list of edge tables (one per group) with at least \code{from}, \code{to}, and \code{weight};
the \code{groups_attributes} element must be a named list of node tables containing, among others,
\code{network_until}, \code{quantity_papers}, \code{prop_tracked_intra_group}, \code{tracked_documents}, and \code{PY.sd}.}

\item{group}{The specific group to visualize (default: "c1g1").}

\item{jaccard_similarity}{Minimum Jaccard similarity threshold for connections (default: 0.1).}

\item{prop_tracked_intra_group_treshold}{Minimum proportion of tracked intra-group documents
for nodes to be included (default: 0.2).}

\item{label_type}{Type of labels to display on nodes ("size" for weighted size or "id" for group IDs).}

\item{label_vertical_position}{Vertical adjustment for node labels (default: 0).}

\item{label_horizontal_position}{Horizontal adjustment for node labels (default: 0).}

\item{label_angle}{Angle for node labels (default: 0).}

\item{time_span}{Optional vector of years to display; if \code{NA}, shows all (default: \code{NA}).}

\item{show_legend}{Logical indicating whether to show the color legend (default: \code{TRUE}).}
}
\value{
A \code{ggplot2} object visualizing the technological trajectories.
}
\description{
Creates a 2D visualization of technological trajectories based on group similarity metrics,
showing the evolution of research groups over time with node size representing group importance
and color representing publication-year deviation.
}
\examples{
\dontrun{
# Compute trajectories first
traj_data <- plot_groups_trajectories(groups_cumulative)

# Visualize a specific group (pass the whole object; the function extracts what it needs internally)
plot_group_trajectories_2d(
  groups_cumulative_trajectories = traj_data,
  group = "c1g5",
  jaccard_similarity = 0.3
)
}

}
