% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectories_core.R
\name{assign_traj_edge_widths}
\alias{assign_traj_edge_widths}
\title{Assign trajectory-specific edge attributes}
\usage{
assign_traj_edge_widths(
  g,
  tr_tbl,
  width_range = c(0.8, 6),
  use_raw_papers = FALSE
)
}
\arguments{
\item{g}{igraph object}

\item{tr_tbl}{Tibble of trajectories with \code{traj_id} and \code{nodes} columns}

\item{width_range}{Numeric range for edge width scaling (default: c(0.8, 6.0))}

\item{use_raw_papers}{Whether to use raw paper counts (TRUE) or
weighted counts (FALSE) for width calculation}
}
\value{
Modified igraph with \code{traj_id} and \code{traj_width} edge attributes
}
\description{
Computes edge-level trajectory identifiers and widths based on
cumulative paper counts along each trajectory path.
}
\keyword{internal}
