% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{des_info}
\alias{des_info}
\title{Produce a graph of design layout, skeletal ANOVA table and data frame with complete design}
\usage{
des_info(
  design.obj,
  nrows,
  ncols,
  brows = NA,
  bcols = NA,
  byrow = TRUE,
  fac.names = NULL,
  fac.sep = c("", " "),
  buffer = NULL,
  plot = TRUE,
  rotation = 0,
  size = 4,
  margin = FALSE,
  save = FALSE,
  savename = paste0(design.obj$parameters$design, "_design"),
  plottype = "pdf",
  return.seed = TRUE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{design.obj}{An \code{agricolae} design object.}

\item{nrows}{The number of rows in the design.}

\item{ncols}{The number of columns in the design.}

\item{brows}{For RCBD only. The number of rows in a block.}

\item{bcols}{For RCBD only. The number of columns in a block.}

\item{byrow}{For split-plot only. Logical (default: \code{TRUE}). Provides a way to arrange plots within whole-plots when there are multiple possible arrangements.}

\item{fac.names}{Allows renaming of the \code{A} level of factorial designs (i.e. those using \code{\link[agricolae:design.ab]{agricolae::design.ab()}}) by passing (optionally named) vectors of new labels to be applied to the factors within a list. See examples and details for more information.}

\item{fac.sep}{The separator used by \code{fac.names}. Used to combine factorial design levels. If a vector of 2 levels is supplied, the first separates factor levels and label, and the second separates the different factors.}

\item{buffer}{The type of buffer. One of edge, row, column, double row, double column, or block (coming soon).}

\item{plot}{Logical (default \code{TRUE}). If \code{TRUE}, display a plot of the generated design. A plot can always be produced later using \code{\link[=autoplot]{autoplot()}}.}

\item{rotation}{Rotate the text output as Treatments within the plot. Allows for easier reading of long treatment labels. Takes positive and negative values being number of degrees of rotation from horizontal.}

\item{size}{Increase or decrease the text size within the plot for treatment labels. Numeric with default value of 4.}

\item{margin}{Logical (default FALSE). Setting to \code{TRUE} will add a margin (white space) between plot and axes.}

\item{save}{One of \code{FALSE} (default)/\code{"none"}, \code{TRUE}/\code{"both"}, \code{"plot"} or \code{"workbook"}. Specifies which output to save.}

\item{savename}{A filename for the design to be saved to. Default is the type of the design combined with "_design".}

\item{plottype}{The type of file to save the plot as. Usually one of \code{"pdf"}, \code{"png"}, or \code{"jpg"}. See \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}} for all possible options.}

\item{return.seed}{Logical (default TRUE). Output the seed used in the design?}

\item{quiet}{Logical (default FALSE). Return the objects without printing output.}

\item{...}{Additional parameters passed to \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}} for saving the plot.}
}
\value{
A list containing a data frame with the complete design, a ggplot object with plot layout, the seed (if \code{return.seed = TRUE}), and the \code{satab} object, allowing repeat output of the \code{satab} table via \code{cat(output$satab)}.
}
\description{
\strong{Deprecated}: \code{des_info()} has been superseded by \code{\link[=design]{design()}}. Please use \code{\link[=design]{design()}} instead.
This function will be removed in a future version.
}
\keyword{internal}
