% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute_labels.R
\name{.permute_labels_factory}
\alias{.permute_labels_factory}
\title{Restricted permutation label factory}
\usage{
.permute_labels_factory(
  cd,
  outcome,
  mode,
  folds,
  perm_stratify,
  time_block,
  block_len,
  seed,
  group_col = NULL,
  batch_col = NULL,
  study_col = NULL,
  time_col = NULL,
  verbose = FALSE
)
}
\arguments{
\item{cd}{data.frame of sample metadata.}

\item{outcome}{outcome column name.}

\item{mode}{resampling mode (subject_grouped, batch_blocked, study_loocv, time_series).}

\item{folds}{list of fold descriptors from \code{LeakSplits}. When compact
splits are used, fold assignments are read from the
\code{fold_assignments} attribute.}

\item{perm_stratify}{logical or "auto"; if TRUE, permute within strata.}

\item{time_block}{time-series block permutation method.}

\item{block_len}{block length for time-series permutations.}

\item{seed}{integer seed.}

\item{group_col, batch_col, study_col}{optional metadata columns.}

\item{time_col}{optional metadata column name for time-series ordering.}

\item{verbose}{logical; print progress messages.}
}
\value{
A function that returns a list of permuted outcome vectors, one per fold.
}
\description{
Builds a closure that generates permuted outcome vectors per fold while
respecting grouping/batch/study/time constraints used in
\code{audit_leakage()}. Numeric outcomes can be stratified by quantiles to
preserve outcome structure under permutation.
}
\keyword{internal}
