% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OCFunctions.R
\name{negateGoDecisions}
\alias{negateGoDecisions}
\title{negateGoDecisions}
\usage{
negateGoDecisions(go_decisions_list, overall_min_nogos = "all")
}
\arguments{
\item{go_decisions_list}{An object of class \code{decision_list},
as returned by \code{\link[bhmbasket]{getGoDecisions}}}

\item{overall_min_nogos}{Either a non-negative integer or the string \code{all}
for the minimum number of cohort-level NoGo decisions required for
an overall NoGo decision, Default: \code{all}}
}
\value{
A list of NoGo decisions of class \code{decision_list}
}
\description{
Negates the go decisions derived with
\code{\link[bhmbasket]{getGoDecisions}}.
}
\details{
This function is intended for implementing decision rules with a
consider zone as
e.g. proposed in "Bayesian design of proof-of-concept trials" by
Fisch et al. (2015).
This approach involves two criteria, Significance and Relevance.
\itemize{
\item Significance: high evidence that the treatment effect is greater
than some smaller value (e.g. treatment effect under H0)
\item Relevance: moderate evidence that the treatment effect is greater
than some larger value (e.g. treatment effect under a certain alternative)
}
The decision for a cohort is then taken as follows:
\itemize{
\item Go decision: Significance and Relevance
\item Consider decision: either Significance, or Relevance, but not both
\item NoGo decision: no Significance and no Relevance
}
In the example below, the following criteria for are implemented for each of
the three cohorts:
\itemize{
\item Significance: \eqn{P(p_j > 0.4) > 0.95}
\item Relevance: \eqn{P(p_j > 0.8) > 0.5}
}
}
\examples{
scenarios_list <- simulateScenarios(
  n_subjects_list     = list(c(10, 20, 30)),
  response_rates_list = list(rep(0.9, 3)),
  n_trials            = 10)

analysis_list <- performAnalyses(
  scenario_list      = scenarios_list,
  target_rates       = rep(0.5, 3),
  n_mcmc_iterations  = 100)

go_decisions_list <- getGoDecisions(
  analyses_list   = analysis_list,
  cohort_names    = c("p_1", "p_2", "p_3",
                      "p_1", "p_2", "p_3"),
  evidence_levels = c(0.5,  0.5,  0.5,
                      0.95, 0.95, 0.95),
  boundary_rules  = quote(c(x[1] > 0.8 & x[4] > 0.4,
                            x[2] > 0.8 & x[5] > 0.4,
                            x[3] > 0.8 & x[6] > 0.4)))

nogo_decisions <- negateGoDecisions(getGoDecisions(
  analyses_list   = analysis_list,
  cohort_names    = c("p_1", "p_2", "p_3",
                      "p_1", "p_2", "p_3"),
  evidence_levels = c(0.5,  0.5,  0.5,
                      0.95, 0.95, 0.95),
  boundary_rules  = quote(c(x[1] > 0.8 | x[4] > 0.4,
                            x[2] > 0.8 | x[5] > 0.4,
                            x[3] > 0.8 | x[6] > 0.4))))

getGoProbabilities(go_decisions_list, nogo_decisions)
}
\references{
Fisch, Roland, et al.
"Bayesian design of proof-of-concept trials."
\emph{Therapeutic innovation & regulatory science} 49.1 (2015): 155-162.
}
\seealso{
\code{\link[bhmbasket]{getGoDecisions}}
}
\author{
Stephan Wojciekowski
}
