% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_predict.R
\name{mrfSampler}
\alias{mrfSampler}
\title{Sample observations from the ordinal MRF}
\usage{
mrfSampler(
  num_states,
  num_variables,
  num_categories,
  pairwise,
  main,
  variable_type = "ordinal",
  baseline_category,
  iter = 1000,
  seed = NULL
)
}
\arguments{
\item{num_states}{The number of states of the ordinal MRF to be generated.}

\item{num_variables}{The number of variables in the ordinal MRF.}

\item{num_categories}{Either a positive integer or a vector of positive
integers of length \code{num_variables}. The number of response categories on top
of the base category: \code{num_categories = 1} generates binary states.}

\item{pairwise}{A symmetric \code{num_variables} by \code{num_variables} matrix of
pairwise interactions. Only its off-diagonal elements are used.}

\item{main}{A \code{num_variables} by \code{max(num_categories)} matrix of
category thresholds. The elements in row \code{i} indicate the thresholds of
variable \code{i}. If \code{num_categories} is a vector, only the first
\code{num_categories[i]} elements are used in row \code{i}. If the Blume-Capel
model is used for the category thresholds for variable \code{i}, then row
\code{i} requires two values (details below); the first is
\eqn{\alpha}{\alpha}, the linear contribution of the Blume-Capel model and
the second is \eqn{\beta}{\beta}, the quadratic contribution.}

\item{variable_type}{What kind of variables are simulated? Can be a single
character string specifying the variable type of all \code{p} variables at
once or a vector of character strings of length \code{p} specifying the type
for each variable separately. Currently, bgm supports ``ordinal'' and
``blume-capel''. Binary variables are automatically treated as ``ordinal''.
Defaults to \code{variable_type = "ordinal"}.}

\item{baseline_category}{An integer vector of length \code{num_variables} specifying the
baseline_category category that is used for the Blume-Capel model (details below).
Can be any integer value between \code{0} and \code{num_categories} (or
\code{num_categories[i]}).}

\item{iter}{The number of iterations used by the Gibbs sampler.
The function provides the last state of the Gibbs sampler as output. By
default set to \code{1e3}.}

\item{seed}{Optional integer seed for reproducibility. If \code{NULL},
a seed is generated from R's random number generator (so \code{set.seed()}
can be used before calling this function).}
}
\value{
A matrix of simulated observations (see [simulate_mrf()]).
}
\description{
`r lifecycle::badge("deprecated")`

`mrfSampler()` was renamed to [simulate_mrf()] as of bgms 0.1.6.3 to
follow the package's naming conventions.
}
\seealso{
[simulate_mrf()] for the current function.
}
\keyword{internal}
