% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractor_functions.R
\name{extractor_functions}
\alias{extractor_functions}
\alias{extract_arguments}
\alias{extract_arguments.bgms}
\alias{extract_arguments.bgmCompare}
\alias{extract_indicators}
\alias{extract_indicators.bgms}
\alias{extract_indicators.bgmCompare}
\alias{extract_posterior_inclusion_probabilities}
\alias{extract_posterior_inclusion_probabilities.bgms}
\alias{extract_sbm}
\alias{extract_sbm.bgms}
\alias{extract_posterior_inclusion_probabilities.bgmCompare}
\alias{extract_indicator_priors}
\alias{extract_indicator_priors.bgms}
\alias{extract_indicator_priors.bgmCompare}
\alias{extract_pairwise_interactions}
\alias{extract_pairwise_interactions.bgms}
\alias{extract_pairwise_interactions.bgmCompare}
\alias{extract_category_thresholds}
\alias{extract_category_thresholds.bgms}
\alias{extract_category_thresholds.bgmCompare}
\alias{extract_group_params}
\alias{extract_group_params.bgmCompare}
\alias{extract_edge_indicators}
\alias{extract_pairwise_thresholds}
\alias{extract_rhat}
\alias{extract_rhat.bgms}
\alias{extract_rhat.bgmCompare}
\alias{extract_ess}
\alias{extract_ess.bgms}
\alias{extract_ess.bgmCompare}
\title{Extractor Functions for bgms Objects}
\usage{
extract_arguments(bgms_object)

\method{extract_arguments}{bgms}(bgms_object)

\method{extract_arguments}{bgmCompare}(bgms_object)

extract_indicators(bgms_object)

\method{extract_indicators}{bgms}(bgms_object)

\method{extract_indicators}{bgmCompare}(bgms_object)

extract_posterior_inclusion_probabilities(bgms_object)

\method{extract_posterior_inclusion_probabilities}{bgms}(bgms_object)

extract_sbm(bgms_object)

\method{extract_sbm}{bgms}(bgms_object)

\method{extract_posterior_inclusion_probabilities}{bgmCompare}(bgms_object)

extract_indicator_priors(bgms_object)

\method{extract_indicator_priors}{bgms}(bgms_object)

\method{extract_indicator_priors}{bgmCompare}(bgms_object)

extract_pairwise_interactions(bgms_object)

\method{extract_pairwise_interactions}{bgms}(bgms_object)

\method{extract_pairwise_interactions}{bgmCompare}(bgms_object)

extract_category_thresholds(bgms_object)

\method{extract_category_thresholds}{bgms}(bgms_object)

\method{extract_category_thresholds}{bgmCompare}(bgms_object)

extract_group_params(bgms_object)

\method{extract_group_params}{bgmCompare}(bgms_object)

extract_edge_indicators(bgms_object)

extract_pairwise_thresholds(bgms_object)

extract_rhat(bgms_object)

\method{extract_rhat}{bgms}(bgms_object)

\method{extract_rhat}{bgmCompare}(bgms_object)

extract_ess(bgms_object)

\method{extract_ess}{bgms}(bgms_object)

\method{extract_ess}{bgmCompare}(bgms_object)
}
\arguments{
\item{bgms_object}{An object of class `bgms` or `bgmCompare`.}
}
\description{
Extractor Functions for bgms Objects
}
\details{
These functions extract various components from objects returned by the `bgm()` function,
such as edge indicators, posterior inclusion probabilities, and parameter summaries.

Internally, indicator samples were stored in `$gamma` (pre-0.1.4, now defunct)
and `$indicator` (0.1.4–0.1.5, deprecated). As of **bgms 0.1.6.0**, they are
stored in `$raw_samples$indicator`.

For \code{bgmCompare} objects, indicator samples were stored in
\code{$pairwise_difference_indicator} and \code{$main_difference_indicator}
(0.1.4–0.1.5, deprecated). As of **bgms 0.1.6.0**, they are
stored in \code{$raw_samples$indicator}.

Posterior inclusion probabilities are computed from edge indicators.

Internally, indicator samples were stored in `$gamma` (pre-0.1.4, now defunct)
and `$indicator` (0.1.4–0.1.5, deprecated). As of **bgms 0.1.6.0**, they are
stored in `$raw_samples$indicator`.

Pairwise interactions were previously stored in `$pairwise_effects` (pre-0.1.4, now
defunct) and `$posterior_mean_pairwise` (0.1.4–0.1.5, deprecated). As of **bgms
0.1.6.0**, they are stored in `$raw_samples$pairwise` (raw samples) and
`$posterior_summary_pairwise` (summaries).

For \code{bgmCompare} objects, pairwise interactions were stored in
\code{$interactions} (0.1.4–0.1.5, deprecated). As of **bgms 0.1.6.0**,
they are stored in \code{$raw_samples$pairwise}.

Category thresholds were previously stored in `$main_effects` (pre-0.1.4, now defunct)
and `$posterior_mean_main` (0.1.4–0.1.5, deprecated). As of **bgms 0.1.6.0**, they
are stored in `$posterior_summary_main`.

For \code{bgmCompare} objects, category thresholds were stored in
\code{$thresholds} (0.1.4–0.1.5, deprecated). As of **bgms 0.1.6.0**,
they are stored in \code{$raw_samples$main}.
}
\section{Functions}{

- `extract_arguments()` – Extract model arguments
- `extract_indicators()` – Get sampled edge indicators
- `extract_posterior_inclusion_probabilities()` – Posterior edge inclusion probabilities
- `extract_pairwise_interactions()` – Posterior mean of pairwise interactions
- `extract_category_thresholds()` – Posterior mean of category thresholds
- `extract_indicator_priors()` – Prior structure used for edge indicators
- `extract_sbm()` – Extract stochastic block model parameters (if applicable)
- `extract_rhat()` – Extract R-hat convergence diagnostics
- `extract_ess()` – Extract effective sample size estimates
}

\keyword{internal}
