% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brsmm-methods.R
\name{nobs.brsmm}
\alias{nobs.brsmm}
\title{Number of observations in a brsmm fit}
\usage{
\method{nobs}{brsmm}(object, ...)
}
\arguments{
\item{object}{A fitted \code{"brsmm"} object.}

\item{...}{Currently ignored.}
}
\value{
Integer.
}
\description{
Number of observations in a brsmm fit
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10),
  id = factor(rep(1:4, each = 5))
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brsmm(y ~ x1, random = ~ 1 | id, data = prep)
nobs(fit)
}

}
\seealso{
\code{\link{brsmm}}, \code{\link{fitted.brsmm}}
}
