% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{compute_start}
\alias{compute_start}
\title{Compute starting values for optimization}
\usage{
compute_start(
  formula,
  data,
  link = "logit",
  link_phi = "logit",
  ncuts = 100L,
  lim = 0.5
)
}
\arguments{
\item{formula}{A \code{\link[Formula]{Formula}} object (possibly
multi-part).}

\item{data}{Data frame.}

\item{link}{Mean link function name.}

\item{link_phi}{Dispersion link function name.}

\item{ncuts}{Number of scale categories.}

\item{lim}{Uncertainty half-width.}
}
\value{
Named numeric vector of starting values.
}
\description{
Obtains rough starting values for the beta regression parameters
by fitting a quasi-binomial GLM on the midpoint response.  This
provides a reasonable initialization for the interval likelihood
optimizer.
}
\keyword{internal}
