% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{BIC.brs}
\alias{BIC.brs}
\title{Bayesian information criterion}
\usage{
\method{BIC}{brs}(object, ...)
}
\arguments{
\item{object}{A fitted \code{"betaregscale"} object.}

\item{...}{Ignored.}
}
\value{
Scalar BIC value.
}
\description{
Bayesian information criterion
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10)
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brs(y ~ x1, data = prep)
BIC(fit)
}

}
\seealso{
\code{\link{brs}}, \code{\link{logLik.brs}}, \code{\link{AIC.brs}},
  \code{\link{brs_gof}}
}
