% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef}
\alias{coef}
\alias{coef.lm_b}
\alias{coef.aov_b}
\alias{coef.np_glm_b}
\alias{coef.glm_b}
\alias{coef.lm_b_bma}
\title{Coefficient extraction for bayesics objects}
\usage{
\method{coef}{lm_b}(object, ...)

\method{coef}{aov_b}(object, ...)

\method{coef}{np_glm_b}(object, ...)

\method{coef}{glm_b}(object, ...)

\method{coef}{lm_b_bma}(object, ...)
}
\arguments{
\item{object}{bayesics object}

\item{...}{optional arguments.}
}
\value{
vector of coefficients
}
\description{
Coefficient extraction for bayesics objects
}
\examples{
\donttest{
set.seed(2025)
N = 500
test_data = 
  data.frame(x1 = rep(letters[1:5],N/5))
test_data$outcome = 
  rnorm(N,-1 + 2 * (test_data$x1 \%in\% c("d","e")) )

# Fit 1-way ANOVA model
fit1 <-
  aov_b(outcome ~ x1,
        test_data,
        prior_mean_mu = 2,
        prior_mean_nu = 0.5,
        prior_var_shape = 0.01,
        prior_var_rate = 0.01)
coef(fit1)
}

}
