% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_details.R
\name{get_details.app}
\alias{get_details.app}
\title{Get Details of a Basket Trial Simulation with the Adaptive Power Prior Design
for sequential clinical trials}
\usage{
\method{get_details}{app}(
  design,
  n,
  p1 = NULL,
  lambda,
  level = 0.95,
  iter = 1000,
  data = NULL,
  ...
)
}
\arguments{
\item{design}{An object of class \code{app}.}

\item{n}{The sample sizes of the baskets. A vector must be used for varying sample sizes.}

\item{p1}{Probabilities used for the simulation. If \code{NULL}
then all probabilities are set to p0.}

\item{lambda}{The posterior probability threshold.}

\item{level}{Level of the credibility intervals.}

\item{iter}{The number of iterations in the simulation. Is ignored if
\code{data} is specified.}

\item{data}{A data matrix with k column with the number of responses for each
basket. Has to be generated with \code{get_data}. If \code{data} is used,
then \code{iter} is ignored.}

\item{...}{Further arguments.}
}
\value{
A list containing the rejection probabilities, posterior means,
mean squared errors and mean limits of HDI intervals for all baskets as well
as the family-wise error rate.
}
\description{
Get Details of a Basket Trial Simulation with the Adaptive Power Prior Design
for sequential clinical trials
}
\examples{
design <- setup_app(k = 3, p0 = 0.2)

# Equal sample sizes
get_details(design = design, n = 20, p1 = c(0.2, 0.5, 0.5),
 lambda = 0.95, iter = 100)

# Unequal sample sizes
get_details(design = design, n = c(15, 20, 25), p1 = c(0.2, 0.5, 0.5),
 lambda = 0.95, iter = 100)
}
