% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage-package.R
\docType{package}
\name{bage-package}
\alias{bage}
\alias{bage-package}
\title{Package 'bage'}
\description{
Bayesian estimation and forecasting of age-specific rates.
Estimation uses \href{https://CRAN.R-project.org/package=TMB}{TMB},
and is fast.
}
\section{Example workflow}{

\enumerate{
\item Specify model using \code{\link[=mod_pois]{mod_pois()}}
\item Fit model using \code{\link[=fit]{fit()}}
\item Extract results using \code{\link[=augment]{augment()}}
\item Check model using \code{\link[=replicate_data]{replicate_data()}}
}
}

\section{Functions}{


\strong{Specify model}
\itemize{
\item \code{\link[=mod_pois]{mod_pois()}} Specify a Poisson model
\item \code{\link[=mod_binom]{mod_binom()}} Specify a binomial model
\item \code{\link[=mod_norm]{mod_norm()}} Specify a normal model
\item \code{\link[=set_prior]{set_prior()}} Specify prior for main effect or interaction
\item \link{priors} Overview of priors for main effects or interactions
\item \code{\link[=set_disp]{set_disp()}} Specify prior for dispersion/variance
\item \code{\link[=set_covariates]{set_covariates()}} Add covariates to model
\item \link{datamods} Overview of data models (measurement error models)
\item \link{confidential} Overview of confidentialization models
}

\strong{Fit model}
\itemize{
\item \code{\link[=fit]{fit()}} Derive posterior distribution
}

\strong{Extract results}
\itemize{
\item \code{\link[=augment]{augment()}} Original data, plus observation-level estimates
\item \link[=components.bage_mod]{components()} Hyper-parameters
\item \code{\link[=dispersion]{dispersion()}} Dispersion parameter (a type of hyper-parameter)
\item \code{\link[=tidy]{tidy()}} One-line summary
\item \code{\link[=set_n_draw]{set_n_draw()}} Specify number of prior or posterior draws
}

\strong{Forecast}
\itemize{
\item \code{\link[=forecast]{forecast()}} Use model to obtain estimates for future periods
}

\strong{Check model}
\itemize{
\item \code{\link[=replicate_data]{replicate_data()}} Compare real and simulated data
\item \code{\link[=report_sim]{report_sim()}} Simulation study of model
}
}

\section{Data}{

\itemize{
\item \link{datasets} Overview of datasets
\item \link{svds} Overview of scaled SVDs
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://bayesiandemography.github.io/bage/}
  \item \url{https://github.com/bayesiandemography/bage}
  \item Report bugs at \url{https://github.com/bayesiandemography/bage/issues}
}

}
\author{
\strong{Maintainer}: John Bryant \email{john@bayesiandemography.com}

Authors:
\itemize{
  \item Junni Zhang \email{junnizhang@163.com}
}

Other contributors:
\itemize{
  \item Bayesian Demography Limited [copyright holder]
}

}
\keyword{internal}
